/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.EligibilityToHoldCollateral;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EligibilityToHoldCollateralCustodian")
@ImplementedBy(value=Default.class)
public interface EligibilityToHoldCollateralCustodian
extends Validator<EligibilityToHoldCollateral> {
    public static final String NAME = "EligibilityToHoldCollateralCustodian";
    public static final String DEFINITION = "if custodianEligibility = True then initialCustodian exists else initialCustodian is absent and custodianCondition is absent";

    public static class NoOp
    implements EligibilityToHoldCollateralCustodian {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EligibilityToHoldCollateral eligibilityToHoldCollateral) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EligibilityToHoldCollateralCustodian {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EligibilityToHoldCollateral eligibilityToHoldCollateral) {
            ComparisonResult result = this.executeDataRule(eligibilityToHoldCollateral);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EligibilityToHoldCollateralCustodian.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EligibilityToHoldCollateral", (RosettaPath)path, (String)EligibilityToHoldCollateralCustodian.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EligibilityToHoldCollateralCustodian.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EligibilityToHoldCollateral", (RosettaPath)path, (String)EligibilityToHoldCollateralCustodian.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EligibilityToHoldCollateral eligibilityToHoldCollateral) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)eligibilityToHoldCollateral).map("getCustodianEligibility", _eligibilityToHoldCollateral -> _eligibilityToHoldCollateral.getCustodianEligibility()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)eligibilityToHoldCollateral).map("getInitialCustodian", _eligibilityToHoldCollateral -> _eligibilityToHoldCollateral.getInitialCustodian()));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)eligibilityToHoldCollateral).map("getInitialCustodian", _eligibilityToHoldCollateral -> _eligibilityToHoldCollateral.getInitialCustodian())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)eligibilityToHoldCollateral).map("getCustodianCondition", _eligibilityToHoldCollateral -> _eligibilityToHoldCollateral.getCustodianCondition())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

