/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.CSAValuationDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSAValuationDateAdditionalLanguage")
@ImplementedBy(value=Default.class)
public interface CSAValuationDateAdditionalLanguage
extends Validator<CSAValuationDate> {
    public static final String NAME = "CSAValuationDateAdditionalLanguage";
    public static final String DEFINITION = "if date is absent or frequency is absent then additionalLanguage exists";

    public static class NoOp
    implements CSAValuationDateAdditionalLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSAValuationDate cSAValuationDate) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSAValuationDateAdditionalLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSAValuationDate cSAValuationDate) {
            ComparisonResult result = this.executeDataRule(cSAValuationDate);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSAValuationDateAdditionalLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSAValuationDate", (RosettaPath)path, (String)CSAValuationDateAdditionalLanguage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSAValuationDateAdditionalLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSAValuationDate", (RosettaPath)path, (String)CSAValuationDateAdditionalLanguage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSAValuationDate cSAValuationDate) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSAValuationDate).map("getDate", _cSAValuationDate -> _cSAValuationDate.getDate())).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSAValuationDate).map("getFrequency", _cSAValuationDate -> _cSAValuationDate.getFrequency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)cSAValuationDate).map("getAdditionalLanguage", _cSAValuationDate -> _cSAValuationDate.getAdditionalLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

