/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.ElectiveAmountElection;
import cdm.legaldocumentation.csa.ElectiveAmountEnum;
import cdm.legaldocumentation.csa.processor.CreateiQMappingHelperUtils;
import cdm.observable.asset.Money;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class ElectiveAmountElectionMappingHelper {
    private static final String ZERO = "zero";
    private final RosettaPath path;
    private final List<Mapping> mappings;
    private final CreateiQMappingHelperUtils createiQMappingHelperUtils;

    public ElectiveAmountElectionMappingHelper(RosettaPath path, List<Mapping> mappings, SynonymToEnumMap synonymToEnumMap) {
        this.path = path;
        this.mappings = mappings;
        this.createiQMappingHelperUtils = new CreateiQMappingHelperUtils(path, mappings, synonymToEnumMap);
    }

    public Optional<ElectiveAmountElection> getElectiveAmountElection(Path synonymPath, String party) {
        ElectiveAmountElection.ElectiveAmountElectionBuilder electiveAmountElectionBuilder = ElectiveAmountElection.builder();
        Money.MoneyBuilder moneyBuilder = this.createiQMappingHelperUtils.getMoneyBuilder(synonymPath, party);
        if (moneyBuilder.hasData()) {
            electiveAmountElectionBuilder.setAmount(moneyBuilder);
        }
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement(party + "_" + synonymPath.getLastElement().getPathName()), value -> {
            electiveAmountElectionBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party));
            if (ZERO.equals(value)) {
                electiveAmountElectionBuilder.setElectiveAmount(ElectiveAmountEnum.ZERO);
            }
        }, this.mappings, (RosettaPath)this.path);
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement(party + "_specify"), value -> electiveAmountElectionBuilder.setCustomElection(CreateiQMappingProcessorUtils.removeHtml(value)), this.mappings, (RosettaPath)this.path);
        return electiveAmountElectionBuilder.hasData() ? Optional.of(electiveAmountElectionBuilder.build()) : Optional.empty();
    }
}

