/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.meta.RatingAgencyAmountMeta;
import cdm.observable.asset.CreditNotation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RatingAgencyAmount", builder=RatingAgencyAmountBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="RatingAgencyAmount", model="cdm", builder=RatingAgencyAmountBuilderImpl.class, version="7.0.0-dev.52")
public interface RatingAgencyAmount
extends RosettaModelObject {
    public static final RatingAgencyAmountMeta metaData = new RatingAgencyAmountMeta();

    public List<? extends CreditNotation> getRatingVariableSet();

    public BigDecimal getAmount();

    public RatingAgencyAmount build();

    public RatingAgencyAmountBuilder toBuilder();

    public static RatingAgencyAmountBuilder builder() {
        return new RatingAgencyAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends RatingAgencyAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RatingAgencyAmount> getType() {
        return RatingAgencyAmount.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("ratingVariableSet"), processor, CreditNotation.class, this.getRatingVariableSet(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RatingAgencyAmountBuilderImpl
    implements RatingAgencyAmountBuilder {
        protected List<CreditNotation.CreditNotationBuilder> ratingVariableSet = new ArrayList<CreditNotation.CreditNotationBuilder>();
        protected BigDecimal amount;

        @Override
        @RosettaAttribute(value="ratingVariableSet", isRequired=true)
        @RuneAttribute(value="ratingVariableSet", isRequired=true)
        public List<? extends CreditNotation.CreditNotationBuilder> getRatingVariableSet() {
            return this.ratingVariableSet;
        }

        @Override
        public CreditNotation.CreditNotationBuilder getOrCreateRatingVariableSet(int index) {
            if (this.ratingVariableSet == null) {
                this.ratingVariableSet = new ArrayList<CreditNotation.CreditNotationBuilder>();
            }
            return (CreditNotation.CreditNotationBuilder)this.getIndex(this.ratingVariableSet, index, () -> {
                CreditNotation.CreditNotationBuilder newRatingVariableSet = CreditNotation.builder();
                return newRatingVariableSet;
            });
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="ratingVariableSet", isRequired=true)
        @RuneAttribute(value="ratingVariableSet", isRequired=true)
        public RatingAgencyAmountBuilder addRatingVariableSet(CreditNotation _ratingVariableSet) {
            if (_ratingVariableSet != null) {
                this.ratingVariableSet.add(_ratingVariableSet.toBuilder());
            }
            return this;
        }

        @Override
        public RatingAgencyAmountBuilder addRatingVariableSet(CreditNotation _ratingVariableSet, int idx) {
            this.getIndex(this.ratingVariableSet, idx, () -> _ratingVariableSet.toBuilder());
            return this;
        }

        @Override
        public RatingAgencyAmountBuilder addRatingVariableSet(List<? extends CreditNotation> ratingVariableSets) {
            if (ratingVariableSets != null) {
                for (CreditNotation creditNotation : ratingVariableSets) {
                    this.ratingVariableSet.add(creditNotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="ratingVariableSet")
        public RatingAgencyAmountBuilder setRatingVariableSet(List<? extends CreditNotation> ratingVariableSets) {
            this.ratingVariableSet = ratingVariableSets == null ? new ArrayList<CreditNotation.CreditNotationBuilder>() : (List)ratingVariableSets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public RatingAgencyAmountBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        public RatingAgencyAmount build() {
            return new RatingAgencyAmountImpl(this);
        }

        @Override
        public RatingAgencyAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public RatingAgencyAmountBuilder prune() {
            this.ratingVariableSet = this.ratingVariableSet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getRatingVariableSet() != null && this.getRatingVariableSet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAmount() != null;
        }

        public RatingAgencyAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RatingAgencyAmountBuilder o = (RatingAgencyAmountBuilder)other;
            merger.mergeRosetta(this.getRatingVariableSet(), o.getRatingVariableSet(), this::getOrCreateRatingVariableSet);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RatingAgencyAmount _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.ratingVariableSet, _that.getRatingVariableSet())) {
                return false;
            }
            return Objects.equals(this.amount, _that.getAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ratingVariableSet != null ? this.ratingVariableSet.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RatingAgencyAmountBuilder {ratingVariableSet=" + this.ratingVariableSet + ", amount=" + this.amount + '}';
        }
    }

    public static interface RatingAgencyAmountBuilder
    extends RatingAgencyAmount,
    RosettaModelObjectBuilder {
        public CreditNotation.CreditNotationBuilder getOrCreateRatingVariableSet(int var1);

        public List<? extends CreditNotation.CreditNotationBuilder> getRatingVariableSet();

        public RatingAgencyAmountBuilder addRatingVariableSet(CreditNotation var1);

        public RatingAgencyAmountBuilder addRatingVariableSet(CreditNotation var1, int var2);

        public RatingAgencyAmountBuilder addRatingVariableSet(List<? extends CreditNotation> var1);

        public RatingAgencyAmountBuilder setRatingVariableSet(List<? extends CreditNotation> var1);

        public RatingAgencyAmountBuilder setAmount(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("ratingVariableSet"), processor, CreditNotation.CreditNotationBuilder.class, this.getRatingVariableSet(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public RatingAgencyAmountBuilder prune();
    }

    public static class RatingAgencyAmountImpl
    implements RatingAgencyAmount {
        private final List<? extends CreditNotation> ratingVariableSet;
        private final BigDecimal amount;

        protected RatingAgencyAmountImpl(RatingAgencyAmountBuilder builder) {
            this.ratingVariableSet = Optional.ofNullable(builder.getRatingVariableSet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.amount = builder.getAmount();
        }

        @Override
        @RosettaAttribute(value="ratingVariableSet", isRequired=true)
        @RuneAttribute(value="ratingVariableSet", isRequired=true)
        public List<? extends CreditNotation> getRatingVariableSet() {
            return this.ratingVariableSet;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public RatingAgencyAmount build() {
            return this;
        }

        @Override
        public RatingAgencyAmountBuilder toBuilder() {
            RatingAgencyAmountBuilder builder = RatingAgencyAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RatingAgencyAmountBuilder builder) {
            Optional.ofNullable(this.getRatingVariableSet()).ifPresent(builder::setRatingVariableSet);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RatingAgencyAmount _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.ratingVariableSet, _that.getRatingVariableSet())) {
                return false;
            }
            return Objects.equals(this.amount, _that.getAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.ratingVariableSet != null ? this.ratingVariableSet.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RatingAgencyAmount {ratingVariableSet=" + this.ratingVariableSet + ", amount=" + this.amount + '}';
        }
    }
}

