/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.meta.IneligibleCreditSupportMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IneligibleCreditSupport", builder=IneligibleCreditSupportBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="IneligibleCreditSupport", model="cdm", builder=IneligibleCreditSupportBuilderImpl.class, version="7.0.0-dev.52")
public interface IneligibleCreditSupport
extends RosettaModelObject {
    public static final IneligibleCreditSupportMeta metaData = new IneligibleCreditSupportMeta();

    public String getTotalIneligibilityDate();

    public String getTransferIneligibilityDate();

    public List<CounterpartyRoleEnum> getSpecifiedParty();

    public IneligibleCreditSupport build();

    public IneligibleCreditSupportBuilder toBuilder();

    public static IneligibleCreditSupportBuilder builder() {
        return new IneligibleCreditSupportBuilderImpl();
    }

    default public RosettaMetaData<? extends IneligibleCreditSupport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IneligibleCreditSupport> getType() {
        return IneligibleCreditSupport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("totalIneligibilityDate"), String.class, (Object)this.getTotalIneligibilityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("transferIneligibilityDate"), String.class, (Object)this.getTransferIneligibilityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specifiedParty"), CounterpartyRoleEnum.class, this.getSpecifiedParty(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class IneligibleCreditSupportBuilderImpl
    implements IneligibleCreditSupportBuilder {
        protected String totalIneligibilityDate;
        protected String transferIneligibilityDate;
        protected List<CounterpartyRoleEnum> specifiedParty = new ArrayList<CounterpartyRoleEnum>();

        @Override
        @RosettaAttribute(value="totalIneligibilityDate")
        @RuneAttribute(value="totalIneligibilityDate")
        public String getTotalIneligibilityDate() {
            return this.totalIneligibilityDate;
        }

        @Override
        @RosettaAttribute(value="transferIneligibilityDate")
        @RuneAttribute(value="transferIneligibilityDate")
        public String getTransferIneligibilityDate() {
            return this.transferIneligibilityDate;
        }

        @Override
        @RosettaAttribute(value="specifiedParty")
        @RuneAttribute(value="specifiedParty")
        public List<CounterpartyRoleEnum> getSpecifiedParty() {
            return this.specifiedParty;
        }

        @Override
        @RosettaAttribute(value="totalIneligibilityDate")
        @RuneAttribute(value="totalIneligibilityDate")
        public IneligibleCreditSupportBuilder setTotalIneligibilityDate(String _totalIneligibilityDate) {
            this.totalIneligibilityDate = _totalIneligibilityDate == null ? null : _totalIneligibilityDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="transferIneligibilityDate")
        @RuneAttribute(value="transferIneligibilityDate")
        public IneligibleCreditSupportBuilder setTransferIneligibilityDate(String _transferIneligibilityDate) {
            this.transferIneligibilityDate = _transferIneligibilityDate == null ? null : _transferIneligibilityDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedParty")
        @RuneAttribute(value="specifiedParty")
        public IneligibleCreditSupportBuilder addSpecifiedParty(CounterpartyRoleEnum _specifiedParty) {
            if (_specifiedParty != null) {
                this.specifiedParty.add(_specifiedParty);
            }
            return this;
        }

        @Override
        public IneligibleCreditSupportBuilder addSpecifiedParty(CounterpartyRoleEnum _specifiedParty, int idx) {
            this.getIndex(this.specifiedParty, idx, () -> _specifiedParty);
            return this;
        }

        @Override
        public IneligibleCreditSupportBuilder addSpecifiedParty(List<CounterpartyRoleEnum> specifiedPartys) {
            if (specifiedPartys != null) {
                for (CounterpartyRoleEnum toAdd : specifiedPartys) {
                    this.specifiedParty.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="specifiedParty")
        public IneligibleCreditSupportBuilder setSpecifiedParty(List<CounterpartyRoleEnum> specifiedPartys) {
            this.specifiedParty = specifiedPartys == null ? new ArrayList<CounterpartyRoleEnum>() : (List)specifiedPartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public IneligibleCreditSupport build() {
            return new IneligibleCreditSupportImpl(this);
        }

        @Override
        public IneligibleCreditSupportBuilder toBuilder() {
            return this;
        }

        @Override
        public IneligibleCreditSupportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getTotalIneligibilityDate() != null) {
                return true;
            }
            if (this.getTransferIneligibilityDate() != null) {
                return true;
            }
            return this.getSpecifiedParty() != null && !this.getSpecifiedParty().isEmpty();
        }

        public IneligibleCreditSupportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IneligibleCreditSupportBuilder o = (IneligibleCreditSupportBuilder)other;
            merger.mergeBasic((Object)this.getTotalIneligibilityDate(), (Object)o.getTotalIneligibilityDate(), this::setTotalIneligibilityDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTransferIneligibilityDate(), (Object)o.getTransferIneligibilityDate(), this::setTransferIneligibilityDate, new AttributeMeta[0]);
            merger.mergeBasic(this.getSpecifiedParty(), o.getSpecifiedParty(), this::addSpecifiedParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IneligibleCreditSupport _that = this.getType().cast(o);
            if (!Objects.equals(this.totalIneligibilityDate, _that.getTotalIneligibilityDate())) {
                return false;
            }
            if (!Objects.equals(this.transferIneligibilityDate, _that.getTransferIneligibilityDate())) {
                return false;
            }
            return ListEquals.listEquals(this.specifiedParty, _that.getSpecifiedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.totalIneligibilityDate != null ? this.totalIneligibilityDate.hashCode() : 0);
            _result = 31 * _result + (this.transferIneligibilityDate != null ? this.transferIneligibilityDate.hashCode() : 0);
            _result = 31 * _result + (this.specifiedParty != null ? this.specifiedParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "IneligibleCreditSupportBuilder {totalIneligibilityDate=" + this.totalIneligibilityDate + ", transferIneligibilityDate=" + this.transferIneligibilityDate + ", specifiedParty=" + this.specifiedParty + '}';
        }
    }

    public static interface IneligibleCreditSupportBuilder
    extends IneligibleCreditSupport,
    RosettaModelObjectBuilder {
        public IneligibleCreditSupportBuilder setTotalIneligibilityDate(String var1);

        public IneligibleCreditSupportBuilder setTransferIneligibilityDate(String var1);

        public IneligibleCreditSupportBuilder addSpecifiedParty(CounterpartyRoleEnum var1);

        public IneligibleCreditSupportBuilder addSpecifiedParty(CounterpartyRoleEnum var1, int var2);

        public IneligibleCreditSupportBuilder addSpecifiedParty(List<CounterpartyRoleEnum> var1);

        public IneligibleCreditSupportBuilder setSpecifiedParty(List<CounterpartyRoleEnum> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("totalIneligibilityDate"), String.class, (Object)this.getTotalIneligibilityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("transferIneligibilityDate"), String.class, (Object)this.getTransferIneligibilityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specifiedParty"), CounterpartyRoleEnum.class, this.getSpecifiedParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public IneligibleCreditSupportBuilder prune();
    }

    public static class IneligibleCreditSupportImpl
    implements IneligibleCreditSupport {
        private final String totalIneligibilityDate;
        private final String transferIneligibilityDate;
        private final List<CounterpartyRoleEnum> specifiedParty;

        protected IneligibleCreditSupportImpl(IneligibleCreditSupportBuilder builder) {
            this.totalIneligibilityDate = builder.getTotalIneligibilityDate();
            this.transferIneligibilityDate = builder.getTransferIneligibilityDate();
            this.specifiedParty = Optional.ofNullable(builder.getSpecifiedParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="totalIneligibilityDate")
        @RuneAttribute(value="totalIneligibilityDate")
        public String getTotalIneligibilityDate() {
            return this.totalIneligibilityDate;
        }

        @Override
        @RosettaAttribute(value="transferIneligibilityDate")
        @RuneAttribute(value="transferIneligibilityDate")
        public String getTransferIneligibilityDate() {
            return this.transferIneligibilityDate;
        }

        @Override
        @RosettaAttribute(value="specifiedParty")
        @RuneAttribute(value="specifiedParty")
        public List<CounterpartyRoleEnum> getSpecifiedParty() {
            return this.specifiedParty;
        }

        @Override
        public IneligibleCreditSupport build() {
            return this;
        }

        @Override
        public IneligibleCreditSupportBuilder toBuilder() {
            IneligibleCreditSupportBuilder builder = IneligibleCreditSupport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IneligibleCreditSupportBuilder builder) {
            Optional.ofNullable(this.getTotalIneligibilityDate()).ifPresent(builder::setTotalIneligibilityDate);
            Optional.ofNullable(this.getTransferIneligibilityDate()).ifPresent(builder::setTransferIneligibilityDate);
            Optional.ofNullable(this.getSpecifiedParty()).ifPresent(builder::setSpecifiedParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IneligibleCreditSupport _that = this.getType().cast(o);
            if (!Objects.equals(this.totalIneligibilityDate, _that.getTotalIneligibilityDate())) {
                return false;
            }
            if (!Objects.equals(this.transferIneligibilityDate, _that.getTransferIneligibilityDate())) {
                return false;
            }
            return ListEquals.listEquals(this.specifiedParty, _that.getSpecifiedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.totalIneligibilityDate != null ? this.totalIneligibilityDate.hashCode() : 0);
            _result = 31 * _result + (this.transferIneligibilityDate != null ? this.transferIneligibilityDate.hashCode() : 0);
            _result = 31 * _result + (this.specifiedParty != null ? this.specifiedParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "IneligibleCreditSupport {totalIneligibilityDate=" + this.totalIneligibilityDate + ", transferIneligibilityDate=" + this.transferIneligibilityDate + ", specifiedParty=" + this.specifiedParty + '}';
        }
    }
}

