/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.LegalEntity;
import cdm.legaldocumentation.csa.EligibilityToHoldCollateralCriteria;
import cdm.legaldocumentation.csa.meta.EligibilityToHoldCollateralMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EligibilityToHoldCollateral", builder=EligibilityToHoldCollateralBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="EligibilityToHoldCollateral", model="cdm", builder=EligibilityToHoldCollateralBuilderImpl.class, version="7.0.0-dev.52")
public interface EligibilityToHoldCollateral
extends RosettaModelObject {
    public static final EligibilityToHoldCollateralMeta metaData = new EligibilityToHoldCollateralMeta();

    public Boolean getCustodianEligibility();

    public LegalEntity getInitialCustodian();

    public EligibilityToHoldCollateralCriteria getCriteria();

    public List<? extends FieldWithMetaString> getEligibleCountry();

    public String getCustodianCondition();

    public EligibilityToHoldCollateral build();

    public EligibilityToHoldCollateralBuilder toBuilder();

    public static EligibilityToHoldCollateralBuilder builder() {
        return new EligibilityToHoldCollateralBuilderImpl();
    }

    default public RosettaMetaData<? extends EligibilityToHoldCollateral> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EligibilityToHoldCollateral> getType() {
        return EligibilityToHoldCollateral.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("custodianEligibility"), Boolean.class, (Object)this.getCustodianEligibility(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialCustodian"), processor, LegalEntity.class, this.getInitialCustodian(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("criteria"), processor, EligibilityToHoldCollateralCriteria.class, this.getCriteria(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eligibleCountry"), processor, FieldWithMetaString.class, this.getEligibleCountry(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("custodianCondition"), String.class, (Object)this.getCustodianCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class EligibilityToHoldCollateralBuilderImpl
    implements EligibilityToHoldCollateralBuilder {
        protected Boolean custodianEligibility;
        protected LegalEntity.LegalEntityBuilder initialCustodian;
        protected EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder criteria;
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> eligibleCountry = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected String custodianCondition;

        @Override
        @RosettaAttribute(value="custodianEligibility", isRequired=true)
        @RuneAttribute(value="custodianEligibility", isRequired=true)
        public Boolean getCustodianEligibility() {
            return this.custodianEligibility;
        }

        @Override
        @RosettaAttribute(value="initialCustodian")
        @RuneAttribute(value="initialCustodian")
        public LegalEntity.LegalEntityBuilder getInitialCustodian() {
            return this.initialCustodian;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateInitialCustodian() {
            LegalEntity.LegalEntityBuilder result = this.initialCustodian != null ? this.initialCustodian : (this.initialCustodian = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="criteria")
        @RuneAttribute(value="criteria")
        public EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder getCriteria() {
            return this.criteria;
        }

        @Override
        public EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder getOrCreateCriteria() {
            EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder result = this.criteria != null ? this.criteria : (this.criteria = EligibilityToHoldCollateralCriteria.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eligibleCountry")
        @RuneAttribute(value="eligibleCountry")
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getEligibleCountry() {
            return this.eligibleCountry;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateEligibleCountry(int index) {
            if (this.eligibleCountry == null) {
                this.eligibleCountry = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.eligibleCountry, index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newEligibleCountry = FieldWithMetaString.builder();
                return newEligibleCountry;
            });
        }

        @Override
        @RosettaAttribute(value="custodianCondition")
        @RuneAttribute(value="custodianCondition")
        public String getCustodianCondition() {
            return this.custodianCondition;
        }

        @Override
        @RosettaAttribute(value="custodianEligibility", isRequired=true)
        @RuneAttribute(value="custodianEligibility", isRequired=true)
        public EligibilityToHoldCollateralBuilder setCustodianEligibility(Boolean _custodianEligibility) {
            this.custodianEligibility = _custodianEligibility == null ? null : _custodianEligibility;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialCustodian")
        @RuneAttribute(value="initialCustodian")
        public EligibilityToHoldCollateralBuilder setInitialCustodian(LegalEntity _initialCustodian) {
            this.initialCustodian = _initialCustodian == null ? null : _initialCustodian.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="criteria")
        @RuneAttribute(value="criteria")
        public EligibilityToHoldCollateralBuilder setCriteria(EligibilityToHoldCollateralCriteria _criteria) {
            this.criteria = _criteria == null ? null : _criteria.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eligibleCountry")
        @RuneAttribute(value="eligibleCountry")
        public EligibilityToHoldCollateralBuilder addEligibleCountry(FieldWithMetaString _eligibleCountry) {
            if (_eligibleCountry != null) {
                this.eligibleCountry.add(_eligibleCountry.toBuilder());
            }
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder addEligibleCountry(FieldWithMetaString _eligibleCountry, int idx) {
            this.getIndex(this.eligibleCountry, idx, () -> _eligibleCountry.toBuilder());
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder addEligibleCountryValue(String _eligibleCountry) {
            this.getOrCreateEligibleCountry(-1).setValue(_eligibleCountry);
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder addEligibleCountryValue(String _eligibleCountry, int idx) {
            this.getOrCreateEligibleCountry(idx).setValue(_eligibleCountry);
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder addEligibleCountry(List<? extends FieldWithMetaString> eligibleCountrys) {
            if (eligibleCountrys != null) {
                for (FieldWithMetaString fieldWithMetaString : eligibleCountrys) {
                    this.eligibleCountry.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eligibleCountry")
        public EligibilityToHoldCollateralBuilder setEligibleCountry(List<? extends FieldWithMetaString> eligibleCountrys) {
            this.eligibleCountry = eligibleCountrys == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)eligibleCountrys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder addEligibleCountryValue(List<? extends String> eligibleCountrys) {
            if (eligibleCountrys != null) {
                for (String string : eligibleCountrys) {
                    this.addEligibleCountryValue(string);
                }
            }
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder setEligibleCountryValue(List<? extends String> eligibleCountrys) {
            this.eligibleCountry.clear();
            if (eligibleCountrys != null) {
                eligibleCountrys.forEach(this::addEligibleCountryValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="custodianCondition")
        @RuneAttribute(value="custodianCondition")
        public EligibilityToHoldCollateralBuilder setCustodianCondition(String _custodianCondition) {
            this.custodianCondition = _custodianCondition == null ? null : _custodianCondition;
            return this;
        }

        @Override
        public EligibilityToHoldCollateral build() {
            return new EligibilityToHoldCollateralImpl(this);
        }

        @Override
        public EligibilityToHoldCollateralBuilder toBuilder() {
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder prune() {
            if (this.initialCustodian != null && !this.initialCustodian.prune().hasData()) {
                this.initialCustodian = null;
            }
            if (this.criteria != null && !this.criteria.prune().hasData()) {
                this.criteria = null;
            }
            this.eligibleCountry = this.eligibleCountry.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCustodianEligibility() != null) {
                return true;
            }
            if (this.getInitialCustodian() != null && this.getInitialCustodian().hasData()) {
                return true;
            }
            if (this.getCriteria() != null && this.getCriteria().hasData()) {
                return true;
            }
            if (this.getEligibleCountry() != null && !this.getEligibleCountry().isEmpty()) {
                return true;
            }
            return this.getCustodianCondition() != null;
        }

        public EligibilityToHoldCollateralBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EligibilityToHoldCollateralBuilder o = (EligibilityToHoldCollateralBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialCustodian(), (RosettaModelObjectBuilder)o.getInitialCustodian(), this::setInitialCustodian);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCriteria(), (RosettaModelObjectBuilder)o.getCriteria(), this::setCriteria);
            merger.mergeRosetta(this.getEligibleCountry(), o.getEligibleCountry(), this::getOrCreateEligibleCountry);
            merger.mergeBasic((Object)this.getCustodianEligibility(), (Object)o.getCustodianEligibility(), this::setCustodianEligibility, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustodianCondition(), (Object)o.getCustodianCondition(), this::setCustodianCondition, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EligibilityToHoldCollateral _that = this.getType().cast(o);
            if (!Objects.equals(this.custodianEligibility, _that.getCustodianEligibility())) {
                return false;
            }
            if (!Objects.equals(this.initialCustodian, _that.getInitialCustodian())) {
                return false;
            }
            if (!Objects.equals(this.criteria, _that.getCriteria())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eligibleCountry, _that.getEligibleCountry())) {
                return false;
            }
            return Objects.equals(this.custodianCondition, _that.getCustodianCondition());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.custodianEligibility != null ? this.custodianEligibility.hashCode() : 0);
            _result = 31 * _result + (this.initialCustodian != null ? this.initialCustodian.hashCode() : 0);
            _result = 31 * _result + (this.criteria != null ? this.criteria.hashCode() : 0);
            _result = 31 * _result + (this.eligibleCountry != null ? this.eligibleCountry.hashCode() : 0);
            _result = 31 * _result + (this.custodianCondition != null ? this.custodianCondition.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EligibilityToHoldCollateralBuilder {custodianEligibility=" + this.custodianEligibility + ", initialCustodian=" + this.initialCustodian + ", criteria=" + this.criteria + ", eligibleCountry=" + this.eligibleCountry + ", custodianCondition=" + this.custodianCondition + '}';
        }
    }

    public static interface EligibilityToHoldCollateralBuilder
    extends EligibilityToHoldCollateral,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateInitialCustodian();

        @Override
        public LegalEntity.LegalEntityBuilder getInitialCustodian();

        public EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder getOrCreateCriteria();

        @Override
        public EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder getCriteria();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateEligibleCountry(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getEligibleCountry();

        public EligibilityToHoldCollateralBuilder setCustodianEligibility(Boolean var1);

        public EligibilityToHoldCollateralBuilder setInitialCustodian(LegalEntity var1);

        public EligibilityToHoldCollateralBuilder setCriteria(EligibilityToHoldCollateralCriteria var1);

        public EligibilityToHoldCollateralBuilder addEligibleCountry(FieldWithMetaString var1);

        public EligibilityToHoldCollateralBuilder addEligibleCountry(FieldWithMetaString var1, int var2);

        public EligibilityToHoldCollateralBuilder addEligibleCountryValue(String var1);

        public EligibilityToHoldCollateralBuilder addEligibleCountryValue(String var1, int var2);

        public EligibilityToHoldCollateralBuilder addEligibleCountry(List<? extends FieldWithMetaString> var1);

        public EligibilityToHoldCollateralBuilder setEligibleCountry(List<? extends FieldWithMetaString> var1);

        public EligibilityToHoldCollateralBuilder addEligibleCountryValue(List<? extends String> var1);

        public EligibilityToHoldCollateralBuilder setEligibleCountryValue(List<? extends String> var1);

        public EligibilityToHoldCollateralBuilder setCustodianCondition(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("custodianEligibility"), Boolean.class, (Object)this.getCustodianEligibility(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialCustodian"), processor, LegalEntity.LegalEntityBuilder.class, this.getInitialCustodian(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("criteria"), processor, EligibilityToHoldCollateralCriteria.EligibilityToHoldCollateralCriteriaBuilder.class, this.getCriteria(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eligibleCountry"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getEligibleCountry(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("custodianCondition"), String.class, (Object)this.getCustodianCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public EligibilityToHoldCollateralBuilder prune();
    }

    public static class EligibilityToHoldCollateralImpl
    implements EligibilityToHoldCollateral {
        private final Boolean custodianEligibility;
        private final LegalEntity initialCustodian;
        private final EligibilityToHoldCollateralCriteria criteria;
        private final List<? extends FieldWithMetaString> eligibleCountry;
        private final String custodianCondition;

        protected EligibilityToHoldCollateralImpl(EligibilityToHoldCollateralBuilder builder) {
            this.custodianEligibility = builder.getCustodianEligibility();
            this.initialCustodian = Optional.ofNullable(builder.getInitialCustodian()).map(f -> f.build()).orElse(null);
            this.criteria = Optional.ofNullable(builder.getCriteria()).map(f -> f.build()).orElse(null);
            this.eligibleCountry = Optional.ofNullable(builder.getEligibleCountry()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.custodianCondition = builder.getCustodianCondition();
        }

        @Override
        @RosettaAttribute(value="custodianEligibility", isRequired=true)
        @RuneAttribute(value="custodianEligibility", isRequired=true)
        public Boolean getCustodianEligibility() {
            return this.custodianEligibility;
        }

        @Override
        @RosettaAttribute(value="initialCustodian")
        @RuneAttribute(value="initialCustodian")
        public LegalEntity getInitialCustodian() {
            return this.initialCustodian;
        }

        @Override
        @RosettaAttribute(value="criteria")
        @RuneAttribute(value="criteria")
        public EligibilityToHoldCollateralCriteria getCriteria() {
            return this.criteria;
        }

        @Override
        @RosettaAttribute(value="eligibleCountry")
        @RuneAttribute(value="eligibleCountry")
        public List<? extends FieldWithMetaString> getEligibleCountry() {
            return this.eligibleCountry;
        }

        @Override
        @RosettaAttribute(value="custodianCondition")
        @RuneAttribute(value="custodianCondition")
        public String getCustodianCondition() {
            return this.custodianCondition;
        }

        @Override
        public EligibilityToHoldCollateral build() {
            return this;
        }

        @Override
        public EligibilityToHoldCollateralBuilder toBuilder() {
            EligibilityToHoldCollateralBuilder builder = EligibilityToHoldCollateral.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EligibilityToHoldCollateralBuilder builder) {
            Optional.ofNullable(this.getCustodianEligibility()).ifPresent(builder::setCustodianEligibility);
            Optional.ofNullable(this.getInitialCustodian()).ifPresent(builder::setInitialCustodian);
            Optional.ofNullable(this.getCriteria()).ifPresent(builder::setCriteria);
            Optional.ofNullable(this.getEligibleCountry()).ifPresent(builder::setEligibleCountry);
            Optional.ofNullable(this.getCustodianCondition()).ifPresent(builder::setCustodianCondition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EligibilityToHoldCollateral _that = this.getType().cast(o);
            if (!Objects.equals(this.custodianEligibility, _that.getCustodianEligibility())) {
                return false;
            }
            if (!Objects.equals(this.initialCustodian, _that.getInitialCustodian())) {
                return false;
            }
            if (!Objects.equals(this.criteria, _that.getCriteria())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eligibleCountry, _that.getEligibleCountry())) {
                return false;
            }
            return Objects.equals(this.custodianCondition, _that.getCustodianCondition());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.custodianEligibility != null ? this.custodianEligibility.hashCode() : 0);
            _result = 31 * _result + (this.initialCustodian != null ? this.initialCustodian.hashCode() : 0);
            _result = 31 * _result + (this.criteria != null ? this.criteria.hashCode() : 0);
            _result = 31 * _result + (this.eligibleCountry != null ? this.eligibleCountry.hashCode() : 0);
            _result = 31 * _result + (this.custodianCondition != null ? this.custodianCondition.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EligibilityToHoldCollateral {custodianEligibility=" + this.custodianEligibility + ", initialCustodian=" + this.initialCustodian + ", criteria=" + this.criteria + ", eligibleCountry=" + this.eligibleCountry + ", custodianCondition=" + this.custodianCondition + '}';
        }
    }
}

