/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.ElectiveAmountEnum;
import cdm.legaldocumentation.csa.meta.ElectiveAmountElectionMeta;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ElectiveAmountElection", builder=ElectiveAmountElectionBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ElectiveAmountElection", model="cdm", builder=ElectiveAmountElectionBuilderImpl.class, version="7.0.0-dev.52")
public interface ElectiveAmountElection
extends RosettaModelObject {
    public static final ElectiveAmountElectionMeta metaData = new ElectiveAmountElectionMeta();

    public CounterpartyRoleEnum getParty();

    public ElectiveAmountEnum getElectiveAmount();

    public Money getAmount();

    public String getCustomElection();

    public ElectiveAmountElection build();

    public ElectiveAmountElectionBuilder toBuilder();

    public static ElectiveAmountElectionBuilder builder() {
        return new ElectiveAmountElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends ElectiveAmountElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ElectiveAmountElection> getType() {
        return ElectiveAmountElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("electiveAmount"), ElectiveAmountEnum.class, (Object)this.getElectiveAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customElection"), String.class, (Object)this.getCustomElection(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ElectiveAmountElectionBuilderImpl
    implements ElectiveAmountElectionBuilder {
        protected CounterpartyRoleEnum party;
        protected ElectiveAmountEnum electiveAmount;
        protected Money.MoneyBuilder amount;
        protected String customElection;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="electiveAmount")
        @RuneAttribute(value="electiveAmount")
        public ElectiveAmountEnum getElectiveAmount() {
            return this.electiveAmount;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public Money.MoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAmount() {
            Money.MoneyBuilder result = this.amount != null ? this.amount : (this.amount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="customElection")
        @RuneAttribute(value="customElection")
        public String getCustomElection() {
            return this.customElection;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public ElectiveAmountElectionBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="electiveAmount")
        @RuneAttribute(value="electiveAmount")
        public ElectiveAmountElectionBuilder setElectiveAmount(ElectiveAmountEnum _electiveAmount) {
            this.electiveAmount = _electiveAmount == null ? null : _electiveAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public ElectiveAmountElectionBuilder setAmount(Money _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="customElection")
        @RuneAttribute(value="customElection")
        public ElectiveAmountElectionBuilder setCustomElection(String _customElection) {
            this.customElection = _customElection == null ? null : _customElection;
            return this;
        }

        @Override
        public ElectiveAmountElection build() {
            return new ElectiveAmountElectionImpl(this);
        }

        @Override
        public ElectiveAmountElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public ElectiveAmountElectionBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getElectiveAmount() != null) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getCustomElection() != null;
        }

        public ElectiveAmountElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ElectiveAmountElectionBuilder o = (ElectiveAmountElectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getElectiveAmount(), (Object)o.getElectiveAmount(), this::setElectiveAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomElection(), (Object)o.getCustomElection(), this::setCustomElection, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ElectiveAmountElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.electiveAmount, (Object)_that.getElectiveAmount())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.customElection, _that.getCustomElection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.electiveAmount != null ? ((Object)((Object)this.electiveAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.customElection != null ? this.customElection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ElectiveAmountElectionBuilder {party=" + (Object)((Object)this.party) + ", electiveAmount=" + (Object)((Object)this.electiveAmount) + ", amount=" + this.amount + ", customElection=" + this.customElection + '}';
        }
    }

    public static interface ElectiveAmountElectionBuilder
    extends ElectiveAmountElection,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateAmount();

        @Override
        public Money.MoneyBuilder getAmount();

        public ElectiveAmountElectionBuilder setParty(CounterpartyRoleEnum var1);

        public ElectiveAmountElectionBuilder setElectiveAmount(ElectiveAmountEnum var1);

        public ElectiveAmountElectionBuilder setAmount(Money var1);

        public ElectiveAmountElectionBuilder setCustomElection(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("electiveAmount"), ElectiveAmountEnum.class, (Object)this.getElectiveAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customElection"), String.class, (Object)this.getCustomElection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ElectiveAmountElectionBuilder prune();
    }

    public static class ElectiveAmountElectionImpl
    implements ElectiveAmountElection {
        private final CounterpartyRoleEnum party;
        private final ElectiveAmountEnum electiveAmount;
        private final Money amount;
        private final String customElection;

        protected ElectiveAmountElectionImpl(ElectiveAmountElectionBuilder builder) {
            this.party = builder.getParty();
            this.electiveAmount = builder.getElectiveAmount();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.customElection = builder.getCustomElection();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="electiveAmount")
        @RuneAttribute(value="electiveAmount")
        public ElectiveAmountEnum getElectiveAmount() {
            return this.electiveAmount;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public Money getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="customElection")
        @RuneAttribute(value="customElection")
        public String getCustomElection() {
            return this.customElection;
        }

        @Override
        public ElectiveAmountElection build() {
            return this;
        }

        @Override
        public ElectiveAmountElectionBuilder toBuilder() {
            ElectiveAmountElectionBuilder builder = ElectiveAmountElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ElectiveAmountElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getElectiveAmount()).ifPresent(builder::setElectiveAmount);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getCustomElection()).ifPresent(builder::setCustomElection);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ElectiveAmountElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.electiveAmount, (Object)_that.getElectiveAmount())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.customElection, _that.getCustomElection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.electiveAmount != null ? ((Object)((Object)this.electiveAmount)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.customElection != null ? this.customElection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ElectiveAmountElection {party=" + (Object)((Object)this.party) + ", electiveAmount=" + (Object)((Object)this.electiveAmount) + ", amount=" + this.amount + ", customElection=" + this.customElection + '}';
        }
    }
}

