/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.legaldocumentation.csa.AdditionalObligations;
import cdm.legaldocumentation.csa.ExposureScope;
import cdm.legaldocumentation.csa.meta.CoveredTransactionsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CoveredTransactions", builder=CoveredTransactionsBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CoveredTransactions", model="cdm", builder=CoveredTransactionsBuilderImpl.class, version="7.0.0-dev.52")
public interface CoveredTransactions
extends RosettaModelObject {
    public static final CoveredTransactionsMeta metaData = new CoveredTransactionsMeta();

    public Date getInclusionDate();

    public List<? extends ProductTaxonomy> getCoveredTransactions();

    public List<String> getBespokeCoveredTransactions();

    public List<? extends AdditionalObligations> getAdditionalObligations();

    public ExposureScope getExposure();

    public CoveredTransactions build();

    public CoveredTransactionsBuilder toBuilder();

    public static CoveredTransactionsBuilder builder() {
        return new CoveredTransactionsBuilderImpl();
    }

    default public RosettaMetaData<? extends CoveredTransactions> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CoveredTransactions> getType() {
        return CoveredTransactions.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("inclusionDate"), Date.class, (Object)this.getInclusionDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("coveredTransactions"), processor, ProductTaxonomy.class, this.getCoveredTransactions(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bespokeCoveredTransactions"), String.class, this.getBespokeCoveredTransactions(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalObligations"), processor, AdditionalObligations.class, this.getAdditionalObligations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exposure"), processor, ExposureScope.class, this.getExposure(), new AttributeMeta[0]);
    }

    public static class CoveredTransactionsBuilderImpl
    implements CoveredTransactionsBuilder {
        protected Date inclusionDate;
        protected List<ProductTaxonomy.ProductTaxonomyBuilder> coveredTransactions = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
        protected List<String> bespokeCoveredTransactions = new ArrayList<String>();
        protected List<AdditionalObligations.AdditionalObligationsBuilder> additionalObligations = new ArrayList<AdditionalObligations.AdditionalObligationsBuilder>();
        protected ExposureScope.ExposureScopeBuilder exposure;

        @Override
        @RosettaAttribute(value="inclusionDate", isRequired=true)
        @RuneAttribute(value="inclusionDate", isRequired=true)
        public Date getInclusionDate() {
            return this.inclusionDate;
        }

        @Override
        @RosettaAttribute(value="coveredTransactions", isRequired=true)
        @RuneAttribute(value="coveredTransactions", isRequired=true)
        public List<? extends ProductTaxonomy.ProductTaxonomyBuilder> getCoveredTransactions() {
            return this.coveredTransactions;
        }

        @Override
        public ProductTaxonomy.ProductTaxonomyBuilder getOrCreateCoveredTransactions(int index) {
            if (this.coveredTransactions == null) {
                this.coveredTransactions = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
            }
            return (ProductTaxonomy.ProductTaxonomyBuilder)this.getIndex(this.coveredTransactions, index, () -> {
                ProductTaxonomy.ProductTaxonomyBuilder newCoveredTransactions = ProductTaxonomy.builder();
                return newCoveredTransactions;
            });
        }

        @Override
        @RosettaAttribute(value="bespokeCoveredTransactions", isRequired=true)
        @RuneAttribute(value="bespokeCoveredTransactions", isRequired=true)
        public List<String> getBespokeCoveredTransactions() {
            return this.bespokeCoveredTransactions;
        }

        @Override
        @RosettaAttribute(value="additionalObligations")
        @RuneAttribute(value="additionalObligations")
        public List<? extends AdditionalObligations.AdditionalObligationsBuilder> getAdditionalObligations() {
            return this.additionalObligations;
        }

        @Override
        public AdditionalObligations.AdditionalObligationsBuilder getOrCreateAdditionalObligations(int index) {
            if (this.additionalObligations == null) {
                this.additionalObligations = new ArrayList<AdditionalObligations.AdditionalObligationsBuilder>();
            }
            return (AdditionalObligations.AdditionalObligationsBuilder)this.getIndex(this.additionalObligations, index, () -> {
                AdditionalObligations.AdditionalObligationsBuilder newAdditionalObligations = AdditionalObligations.builder();
                return newAdditionalObligations;
            });
        }

        @Override
        @RosettaAttribute(value="exposure")
        @RuneAttribute(value="exposure")
        public ExposureScope.ExposureScopeBuilder getExposure() {
            return this.exposure;
        }

        @Override
        public ExposureScope.ExposureScopeBuilder getOrCreateExposure() {
            ExposureScope.ExposureScopeBuilder result = this.exposure != null ? this.exposure : (this.exposure = ExposureScope.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="inclusionDate", isRequired=true)
        @RuneAttribute(value="inclusionDate", isRequired=true)
        public CoveredTransactionsBuilder setInclusionDate(Date _inclusionDate) {
            this.inclusionDate = _inclusionDate == null ? null : _inclusionDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="coveredTransactions", isRequired=true)
        @RuneAttribute(value="coveredTransactions", isRequired=true)
        public CoveredTransactionsBuilder addCoveredTransactions(ProductTaxonomy _coveredTransactions) {
            if (_coveredTransactions != null) {
                this.coveredTransactions.add(_coveredTransactions.toBuilder());
            }
            return this;
        }

        @Override
        public CoveredTransactionsBuilder addCoveredTransactions(ProductTaxonomy _coveredTransactions, int idx) {
            this.getIndex(this.coveredTransactions, idx, () -> _coveredTransactions.toBuilder());
            return this;
        }

        @Override
        public CoveredTransactionsBuilder addCoveredTransactions(List<? extends ProductTaxonomy> coveredTransactionss) {
            if (coveredTransactionss != null) {
                for (ProductTaxonomy productTaxonomy : coveredTransactionss) {
                    this.coveredTransactions.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="coveredTransactions")
        public CoveredTransactionsBuilder setCoveredTransactions(List<? extends ProductTaxonomy> coveredTransactionss) {
            this.coveredTransactions = coveredTransactionss == null ? new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>() : (List)coveredTransactionss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="bespokeCoveredTransactions", isRequired=true)
        @RuneAttribute(value="bespokeCoveredTransactions", isRequired=true)
        public CoveredTransactionsBuilder addBespokeCoveredTransactions(String _bespokeCoveredTransactions) {
            if (_bespokeCoveredTransactions != null) {
                this.bespokeCoveredTransactions.add(_bespokeCoveredTransactions);
            }
            return this;
        }

        @Override
        public CoveredTransactionsBuilder addBespokeCoveredTransactions(String _bespokeCoveredTransactions, int idx) {
            this.getIndex(this.bespokeCoveredTransactions, idx, () -> _bespokeCoveredTransactions);
            return this;
        }

        @Override
        public CoveredTransactionsBuilder addBespokeCoveredTransactions(List<String> bespokeCoveredTransactionss) {
            if (bespokeCoveredTransactionss != null) {
                for (String toAdd : bespokeCoveredTransactionss) {
                    this.bespokeCoveredTransactions.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="bespokeCoveredTransactions")
        public CoveredTransactionsBuilder setBespokeCoveredTransactions(List<String> bespokeCoveredTransactionss) {
            this.bespokeCoveredTransactions = bespokeCoveredTransactionss == null ? new ArrayList<String>() : (List)bespokeCoveredTransactionss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalObligations")
        @RuneAttribute(value="additionalObligations")
        public CoveredTransactionsBuilder addAdditionalObligations(AdditionalObligations _additionalObligations) {
            if (_additionalObligations != null) {
                this.additionalObligations.add(_additionalObligations.toBuilder());
            }
            return this;
        }

        @Override
        public CoveredTransactionsBuilder addAdditionalObligations(AdditionalObligations _additionalObligations, int idx) {
            this.getIndex(this.additionalObligations, idx, () -> _additionalObligations.toBuilder());
            return this;
        }

        @Override
        public CoveredTransactionsBuilder addAdditionalObligations(List<? extends AdditionalObligations> additionalObligationss) {
            if (additionalObligationss != null) {
                for (AdditionalObligations additionalObligations : additionalObligationss) {
                    this.additionalObligations.add(additionalObligations.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalObligations")
        public CoveredTransactionsBuilder setAdditionalObligations(List<? extends AdditionalObligations> additionalObligationss) {
            this.additionalObligations = additionalObligationss == null ? new ArrayList<AdditionalObligations.AdditionalObligationsBuilder>() : (List)additionalObligationss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exposure")
        @RuneAttribute(value="exposure")
        public CoveredTransactionsBuilder setExposure(ExposureScope _exposure) {
            this.exposure = _exposure == null ? null : _exposure.toBuilder();
            return this;
        }

        @Override
        public CoveredTransactions build() {
            return new CoveredTransactionsImpl(this);
        }

        @Override
        public CoveredTransactionsBuilder toBuilder() {
            return this;
        }

        @Override
        public CoveredTransactionsBuilder prune() {
            this.coveredTransactions = this.coveredTransactions.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.additionalObligations = this.additionalObligations.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.exposure != null && !this.exposure.prune().hasData()) {
                this.exposure = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInclusionDate() != null) {
                return true;
            }
            if (this.getCoveredTransactions() != null && this.getCoveredTransactions().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBespokeCoveredTransactions() != null && !this.getBespokeCoveredTransactions().isEmpty()) {
                return true;
            }
            if (this.getAdditionalObligations() != null && this.getAdditionalObligations().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExposure() != null && this.getExposure().hasData();
        }

        public CoveredTransactionsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CoveredTransactionsBuilder o = (CoveredTransactionsBuilder)other;
            merger.mergeRosetta(this.getCoveredTransactions(), o.getCoveredTransactions(), this::getOrCreateCoveredTransactions);
            merger.mergeRosetta(this.getAdditionalObligations(), o.getAdditionalObligations(), this::getOrCreateAdditionalObligations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExposure(), (RosettaModelObjectBuilder)o.getExposure(), this::setExposure);
            merger.mergeBasic((Object)this.getInclusionDate(), (Object)o.getInclusionDate(), this::setInclusionDate, new AttributeMeta[0]);
            merger.mergeBasic(this.getBespokeCoveredTransactions(), o.getBespokeCoveredTransactions(), this::addBespokeCoveredTransactions);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CoveredTransactions _that = this.getType().cast(o);
            if (!Objects.equals(this.inclusionDate, _that.getInclusionDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.coveredTransactions, _that.getCoveredTransactions())) {
                return false;
            }
            if (!ListEquals.listEquals(this.bespokeCoveredTransactions, _that.getBespokeCoveredTransactions())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalObligations, _that.getAdditionalObligations())) {
                return false;
            }
            return Objects.equals(this.exposure, _that.getExposure());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inclusionDate != null ? this.inclusionDate.hashCode() : 0);
            _result = 31 * _result + (this.coveredTransactions != null ? this.coveredTransactions.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCoveredTransactions != null ? this.bespokeCoveredTransactions.hashCode() : 0);
            _result = 31 * _result + (this.additionalObligations != null ? this.additionalObligations.hashCode() : 0);
            _result = 31 * _result + (this.exposure != null ? this.exposure.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CoveredTransactionsBuilder {inclusionDate=" + this.inclusionDate + ", coveredTransactions=" + this.coveredTransactions + ", bespokeCoveredTransactions=" + this.bespokeCoveredTransactions + ", additionalObligations=" + this.additionalObligations + ", exposure=" + this.exposure + '}';
        }
    }

    public static interface CoveredTransactionsBuilder
    extends CoveredTransactions,
    RosettaModelObjectBuilder {
        public ProductTaxonomy.ProductTaxonomyBuilder getOrCreateCoveredTransactions(int var1);

        public List<? extends ProductTaxonomy.ProductTaxonomyBuilder> getCoveredTransactions();

        public AdditionalObligations.AdditionalObligationsBuilder getOrCreateAdditionalObligations(int var1);

        public List<? extends AdditionalObligations.AdditionalObligationsBuilder> getAdditionalObligations();

        public ExposureScope.ExposureScopeBuilder getOrCreateExposure();

        @Override
        public ExposureScope.ExposureScopeBuilder getExposure();

        public CoveredTransactionsBuilder setInclusionDate(Date var1);

        public CoveredTransactionsBuilder addCoveredTransactions(ProductTaxonomy var1);

        public CoveredTransactionsBuilder addCoveredTransactions(ProductTaxonomy var1, int var2);

        public CoveredTransactionsBuilder addCoveredTransactions(List<? extends ProductTaxonomy> var1);

        public CoveredTransactionsBuilder setCoveredTransactions(List<? extends ProductTaxonomy> var1);

        public CoveredTransactionsBuilder addBespokeCoveredTransactions(String var1);

        public CoveredTransactionsBuilder addBespokeCoveredTransactions(String var1, int var2);

        public CoveredTransactionsBuilder addBespokeCoveredTransactions(List<String> var1);

        public CoveredTransactionsBuilder setBespokeCoveredTransactions(List<String> var1);

        public CoveredTransactionsBuilder addAdditionalObligations(AdditionalObligations var1);

        public CoveredTransactionsBuilder addAdditionalObligations(AdditionalObligations var1, int var2);

        public CoveredTransactionsBuilder addAdditionalObligations(List<? extends AdditionalObligations> var1);

        public CoveredTransactionsBuilder setAdditionalObligations(List<? extends AdditionalObligations> var1);

        public CoveredTransactionsBuilder setExposure(ExposureScope var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("inclusionDate"), Date.class, (Object)this.getInclusionDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("coveredTransactions"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getCoveredTransactions(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bespokeCoveredTransactions"), String.class, this.getBespokeCoveredTransactions(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalObligations"), processor, AdditionalObligations.AdditionalObligationsBuilder.class, this.getAdditionalObligations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exposure"), processor, ExposureScope.ExposureScopeBuilder.class, this.getExposure(), new AttributeMeta[0]);
        }

        public CoveredTransactionsBuilder prune();
    }

    public static class CoveredTransactionsImpl
    implements CoveredTransactions {
        private final Date inclusionDate;
        private final List<? extends ProductTaxonomy> coveredTransactions;
        private final List<String> bespokeCoveredTransactions;
        private final List<? extends AdditionalObligations> additionalObligations;
        private final ExposureScope exposure;

        protected CoveredTransactionsImpl(CoveredTransactionsBuilder builder) {
            this.inclusionDate = builder.getInclusionDate();
            this.coveredTransactions = Optional.ofNullable(builder.getCoveredTransactions()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.bespokeCoveredTransactions = Optional.ofNullable(builder.getBespokeCoveredTransactions()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.additionalObligations = Optional.ofNullable(builder.getAdditionalObligations()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.exposure = Optional.ofNullable(builder.getExposure()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="inclusionDate", isRequired=true)
        @RuneAttribute(value="inclusionDate", isRequired=true)
        public Date getInclusionDate() {
            return this.inclusionDate;
        }

        @Override
        @RosettaAttribute(value="coveredTransactions", isRequired=true)
        @RuneAttribute(value="coveredTransactions", isRequired=true)
        public List<? extends ProductTaxonomy> getCoveredTransactions() {
            return this.coveredTransactions;
        }

        @Override
        @RosettaAttribute(value="bespokeCoveredTransactions", isRequired=true)
        @RuneAttribute(value="bespokeCoveredTransactions", isRequired=true)
        public List<String> getBespokeCoveredTransactions() {
            return this.bespokeCoveredTransactions;
        }

        @Override
        @RosettaAttribute(value="additionalObligations")
        @RuneAttribute(value="additionalObligations")
        public List<? extends AdditionalObligations> getAdditionalObligations() {
            return this.additionalObligations;
        }

        @Override
        @RosettaAttribute(value="exposure")
        @RuneAttribute(value="exposure")
        public ExposureScope getExposure() {
            return this.exposure;
        }

        @Override
        public CoveredTransactions build() {
            return this;
        }

        @Override
        public CoveredTransactionsBuilder toBuilder() {
            CoveredTransactionsBuilder builder = CoveredTransactions.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CoveredTransactionsBuilder builder) {
            Optional.ofNullable(this.getInclusionDate()).ifPresent(builder::setInclusionDate);
            Optional.ofNullable(this.getCoveredTransactions()).ifPresent(builder::setCoveredTransactions);
            Optional.ofNullable(this.getBespokeCoveredTransactions()).ifPresent(builder::setBespokeCoveredTransactions);
            Optional.ofNullable(this.getAdditionalObligations()).ifPresent(builder::setAdditionalObligations);
            Optional.ofNullable(this.getExposure()).ifPresent(builder::setExposure);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CoveredTransactions _that = this.getType().cast(o);
            if (!Objects.equals(this.inclusionDate, _that.getInclusionDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.coveredTransactions, _that.getCoveredTransactions())) {
                return false;
            }
            if (!ListEquals.listEquals(this.bespokeCoveredTransactions, _that.getBespokeCoveredTransactions())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalObligations, _that.getAdditionalObligations())) {
                return false;
            }
            return Objects.equals(this.exposure, _that.getExposure());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inclusionDate != null ? this.inclusionDate.hashCode() : 0);
            _result = 31 * _result + (this.coveredTransactions != null ? this.coveredTransactions.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCoveredTransactions != null ? this.bespokeCoveredTransactions.hashCode() : 0);
            _result = 31 * _result + (this.additionalObligations != null ? this.additionalObligations.hashCode() : 0);
            _result = 31 * _result + (this.exposure != null ? this.exposure.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CoveredTransactions {inclusionDate=" + this.inclusionDate + ", coveredTransactions=" + this.coveredTransactions + ", bespokeCoveredTransactions=" + this.bespokeCoveredTransactions + ", additionalObligations=" + this.additionalObligations + ", exposure=" + this.exposure + '}';
        }
    }
}

