/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.tradestate.functions;

import cdm.event.common.TradeState;
import cdm.event.common.TransferState;
import cdm.ingest.fpml.confirmation.payment.functions.MapTransferStateList;
import cdm.ingest.fpml.confirmation.tradestate.functions.MapTrade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapTradeStateDefault.class)
public abstract class MapTradeState
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapTrade mapTrade;
    @Inject
    protected MapTransferStateList mapTransferStateList;

    public TradeState evaluate(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
        TradeState tradeState;
        TradeState.TradeStateBuilder tradeStateBuilder = this.doEvaluate(fpmlTrade, fpmlPartiesAndAccountsModel);
        if (tradeStateBuilder == null) {
            tradeState = null;
        } else {
            tradeState = tradeStateBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)tradeState);
        }
        return tradeState;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(Trade var1, PartiesAndAccountsModel var2);

    public static class MapTradeStateDefault
    extends MapTradeState {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            TradeState.TradeStateBuilder tradeState = TradeState.builder();
            return this.assignOutput(tradeState, fpmlTrade, fpmlPartiesAndAccountsModel);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder tradeState, Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            tradeState = (TradeState.TradeStateBuilder)this.toBuilder(TradeState.builder().setTrade(this.mapTrade.evaluate(fpmlTrade, fpmlPartiesAndAccountsModel)).setTransferHistory(new ArrayList<TransferState>(this.mapTransferStateList.evaluate(fpmlTrade))).build());
            return Optional.ofNullable(tradeState).map(o -> o.prune()).orElse(null);
        }
    }
}

