/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.settlement.functions;

import cdm.ingest.fpml.confirmation.common.functions.MapInformationSource;
import cdm.ingest.fpml.confirmation.settlement.functions.MapReferenceBanks;
import cdm.observable.asset.CashCollateralValuationMethod;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.asset.ValuationMethod;
import cdm.observable.asset.ValuationSource;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.fpmlenum.QuotationRateTypeEnum;
import fpml.consolidated.shared.CashSettlementReferenceBanks;
import fpml.consolidated.shared.InformationSource;
import fpml.consolidated.shared.SettlementRateSource;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapValuationMethodDefault.class)
public abstract class MapValuationMethod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapInformationSource mapInformationSource;
    @Inject
    protected MapReferenceBanks mapReferenceBanks;

    public ValuationMethod evaluate(SettlementRateSource fpmlSettlementRateSource, CashSettlementReferenceBanks fpmlCashSettlementReferenceBanks, QuotationRateTypeEnum fpmlQuotationRateType, CashCollateralValuationMethod cdmCashCollateralValuationMethod) {
        ValuationMethod valuationMethod;
        ValuationMethod.ValuationMethodBuilder valuationMethodBuilder = this.doEvaluate(fpmlSettlementRateSource, fpmlCashSettlementReferenceBanks, fpmlQuotationRateType, cdmCashCollateralValuationMethod);
        if (valuationMethodBuilder == null) {
            valuationMethod = null;
        } else {
            valuationMethod = valuationMethodBuilder.build();
            this.objectValidator.validate(ValuationMethod.class, (RosettaModelObject)valuationMethod);
        }
        return valuationMethod;
    }

    protected abstract ValuationMethod.ValuationMethodBuilder doEvaluate(SettlementRateSource var1, CashSettlementReferenceBanks var2, QuotationRateTypeEnum var3, CashCollateralValuationMethod var4);

    public static class MapValuationMethodDefault
    extends MapValuationMethod {
        @Override
        protected ValuationMethod.ValuationMethodBuilder doEvaluate(SettlementRateSource fpmlSettlementRateSource, CashSettlementReferenceBanks fpmlCashSettlementReferenceBanks, QuotationRateTypeEnum fpmlQuotationRateType, CashCollateralValuationMethod cdmCashCollateralValuationMethod) {
            ValuationMethod.ValuationMethodBuilder valuationMethod = ValuationMethod.builder();
            return this.assignOutput(valuationMethod, fpmlSettlementRateSource, fpmlCashSettlementReferenceBanks, fpmlQuotationRateType, cdmCashCollateralValuationMethod);
        }

        protected ValuationMethod.ValuationMethodBuilder assignOutput(ValuationMethod.ValuationMethodBuilder valuationMethod, SettlementRateSource fpmlSettlementRateSource, CashSettlementReferenceBanks fpmlCashSettlementReferenceBanks, QuotationRateTypeEnum fpmlQuotationRateType, CashCollateralValuationMethod cdmCashCollateralValuationMethod) {
            valuationMethod = (ValuationMethod.ValuationMethodBuilder)this.toBuilder(ValuationMethod.builder().setValuationSource(ValuationSource.builder().setQuotedCurrencyPairValue(null).setInformationSource(FxSpotRateSource.builder().setPrimarySource(this.mapInformationSource.evaluate((InformationSource)MapperS.of((Object)fpmlSettlementRateSource).map("getInformationSource", settlementRateSource -> settlementRateSource.getInformationSource()).get())).build()).setReferenceBanks(this.mapReferenceBanks.evaluate(fpmlCashSettlementReferenceBanks)).build()).setQuotationMethod((cdm.observable.asset.QuotationRateTypeEnum)((Object)MapperS.of((Object)((Object)fpmlQuotationRateType)).checkedMap("to-enum", e -> cdm.observable.asset.QuotationRateTypeEnum.valueOf(e.name()), IllegalArgumentException.class).get())).setCashCollateralValuationMethod(cdmCashCollateralValuationMethod).build());
            return Optional.ofNullable(valuationMethod).map(o -> o.prune()).orElse(null);
        }
    }
}

