/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.varianceswap.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.common.functions.MapAdjustableOrRelativeDateToObservationTerms;
import cdm.ingest.fpml.confirmation.datetime.functions.MapPerformanceValuationDates;
import cdm.ingest.fpml.confirmation.party.functions.MapPayerReceiver;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapNotionalAmountToQuantityWithAddress;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapUnderlyerToObservableWithAddress;
import cdm.ingest.fpml.confirmation.product.varianceswap.functions.MapVarianceLegToVarianceReturnTerms;
import cdm.ingest.fpml.confirmation.settlement.functions.MapOptionSettlementModelToSettlementTerms;
import cdm.observable.asset.ValuationDates;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.ReturnTerms;
import cdm.product.template.Underlier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.EquityValuation;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.variance.swaps.VarianceLeg;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapVarianceLegToPerformancePayoutDefault.class)
public abstract class MapVarianceLegToPerformancePayout
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustableOrRelativeDateToObservationTerms mapAdjustableOrRelativeDateToObservationTerms;
    @Inject
    protected MapNotionalAmountToQuantityWithAddress mapNotionalAmountToQuantityWithAddress;
    @Inject
    protected MapOptionSettlementModelToSettlementTerms mapOptionSettlementModelToSettlementTerms;
    @Inject
    protected MapPayerReceiver mapPayerReceiver;
    @Inject
    protected MapPerformanceValuationDates mapPerformanceValuationDates;
    @Inject
    protected MapUnderlyerToObservableWithAddress mapUnderlyerToObservableWithAddress;
    @Inject
    protected MapVarianceLegToVarianceReturnTerms mapVarianceLegToVarianceReturnTerms;

    public Payout evaluate(VarianceLeg fpmlVarianceLeg, List<? extends Counterparty> cdmCounterpartyList) {
        Payout payout;
        Payout.PayoutBuilder payoutBuilder = this.doEvaluate(fpmlVarianceLeg, cdmCounterpartyList);
        if (payoutBuilder == null) {
            payout = null;
        } else {
            payout = payoutBuilder.build();
            this.objectValidator.validate(Payout.class, (RosettaModelObject)payout);
        }
        return payout;
    }

    protected abstract Payout.PayoutBuilder doEvaluate(VarianceLeg var1, List<? extends Counterparty> var2);

    public static class MapVarianceLegToPerformancePayoutDefault
    extends MapVarianceLegToPerformancePayout {
        @Override
        protected Payout.PayoutBuilder doEvaluate(VarianceLeg fpmlVarianceLeg, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            Payout.PayoutBuilder payout = Payout.builder();
            return this.assignOutput(payout, fpmlVarianceLeg, cdmCounterpartyList);
        }

        protected Payout.PayoutBuilder assignOutput(Payout.PayoutBuilder payout, VarianceLeg fpmlVarianceLeg, List<? extends Counterparty> cdmCounterpartyList) {
            payout = (Payout.PayoutBuilder)this.toBuilder(Payout.builder().setPerformancePayout(PerformancePayout.builder().setPayerReceiver(this.mapPayerReceiver.evaluate((PayerReceiverModel)MapperS.of((Object)fpmlVarianceLeg).map("getPayerReceiverModel", varianceLeg -> varianceLeg.getPayerReceiverModel()).get(), cdmCounterpartyList)).setPriceQuantity(ResolvablePriceQuantity.builder().setQuantitySchedule(this.mapNotionalAmountToQuantityWithAddress.evaluate((BigDecimal)MapperS.of((Object)fpmlVarianceLeg).map("getAmount", varianceLeg -> varianceLeg.getAmount()).map("getVariance", varianceAmount -> varianceAmount.getVariance()).map("getVarianceAmount", variance -> variance.getVarianceAmount()).map("getAmount", nonNegativeMoney -> nonNegativeMoney.getAmount()).get(), fpmlVarianceLeg)).build()).setSettlementTerms(this.mapOptionSettlementModelToSettlementTerms.evaluate((OptionSettlementModel)MapperS.of((Object)fpmlVarianceLeg).map("getOptionSettlementModel", varianceLeg -> varianceLeg.getOptionSettlementModel()).get())).setObservationTerms(this.mapAdjustableOrRelativeDateToObservationTerms.evaluate((AdjustableOrRelativeDate)MapperS.of((Object)fpmlVarianceLeg).map("getAmount", varianceLeg -> varianceLeg.getAmount()).map("getObservationStartDate", varianceAmount -> varianceAmount.getObservationStartDate()).get())).setUnderlier(Underlier.builder().setObservable(this.mapUnderlyerToObservableWithAddress.evaluate((Underlyer)MapperS.of((Object)fpmlVarianceLeg).map("getUnderlyer", varianceLeg -> varianceLeg.getUnderlyer()).get())).build()).setValuationDates(ValuationDates.builder().setFinalValuationDate(this.mapPerformanceValuationDates.evaluate(null, (EquityValuation)MapperS.of((Object)fpmlVarianceLeg).map("getValuation", varianceLeg -> varianceLeg.getValuation()).get())).build()).setPaymentDates(null).setReturnTerms(ReturnTerms.builder().setVarianceReturnTerms(this.mapVarianceLegToVarianceReturnTerms.evaluate(fpmlVarianceLeg)).build()).build()).build());
            return Optional.ofNullable(payout).map(o -> o.prune()).orElse(null);
        }
    }
}

