/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.swap.functions;

import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.common.functions.MapFxSpotRateSource;
import cdm.ingest.fpml.confirmation.datetime.functions.MapBusinessCenterTime;
import cdm.ingest.fpml.confirmation.datetime.functions.MapRelativeDateOffset;
import cdm.product.common.schedule.FxLinkedNotionalSchedule;
import cdm.product.common.settlement.QuantityMultiplier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.ird.Calculation;
import fpml.consolidated.shared.BusinessCenterTime;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.FxSpotRateSource;
import fpml.consolidated.shared.RelativeDateOffset;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapQuantityMultiplierDefault.class)
public abstract class MapQuantityMultiplier
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapBusinessCenterTime mapBusinessCenterTime;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapFxSpotRateSource mapFxSpotRateSource;
    @Inject
    protected MapRelativeDateOffset mapRelativeDateOffset;

    public QuantityMultiplier evaluate(Calculation fpmlCalculation) {
        QuantityMultiplier quantityMultiplier;
        QuantityMultiplier.QuantityMultiplierBuilder quantityMultiplierBuilder = this.doEvaluate(fpmlCalculation);
        if (quantityMultiplierBuilder == null) {
            quantityMultiplier = null;
        } else {
            quantityMultiplier = quantityMultiplierBuilder.build();
            this.objectValidator.validate(QuantityMultiplier.class, (RosettaModelObject)quantityMultiplier);
        }
        return quantityMultiplier;
    }

    protected abstract QuantityMultiplier.QuantityMultiplierBuilder doEvaluate(Calculation var1);

    public static class MapQuantityMultiplierDefault
    extends MapQuantityMultiplier {
        @Override
        protected QuantityMultiplier.QuantityMultiplierBuilder doEvaluate(Calculation fpmlCalculation) {
            QuantityMultiplier.QuantityMultiplierBuilder quantityMultiplier = QuantityMultiplier.builder();
            return this.assignOutput(quantityMultiplier, fpmlCalculation);
        }

        protected QuantityMultiplier.QuantityMultiplierBuilder assignOutput(QuantityMultiplier.QuantityMultiplierBuilder quantityMultiplier, Calculation fpmlCalculation) {
            MapperS thenArg = MapperS.of((Object)fpmlCalculation).map("getFxLinkedNotionalSchedule", calculation -> calculation.getFxLinkedNotionalSchedule());
            quantityMultiplier = (QuantityMultiplier.QuantityMultiplierBuilder)this.toBuilder(QuantityMultiplier.builder().setFxLinkedNotionalSchedule((FxLinkedNotionalSchedule)thenArg.mapSingleToItem(item -> MapperS.of((Object)FxLinkedNotionalSchedule.builder().setVaryingNotionalCurrency(this.mapCurrency.evaluate((Currency)item.map("getVaryingNotionalCurrency", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getVaryingNotionalCurrency()).get())).setVaryingNotionalFixingDates(this.mapRelativeDateOffset.evaluate((RelativeDateOffset)item.map("getVaryingNotionalFixingDates", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getVaryingNotionalFixingDates()).get())).setFxSpotRateSource(this.mapFxSpotRateSource.evaluate((FxSpotRateSource)item.map("getFxSpotRateSource", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getFxSpotRateSource()).get())).setVaryingNotionalInterimExchangePaymentDates(this.mapRelativeDateOffset.evaluate((RelativeDateOffset)item.map("getVaryingNotionalInterimExchangePaymentDates", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getVaryingNotionalInterimExchangePaymentDates()).get())).setFixingTime(this.mapBusinessCenterTime.evaluate((BusinessCenterTime)item.map("getFxSpotRateSource", fxLinkedNotionalSchedule -> fxLinkedNotionalSchedule.getFxSpotRateSource()).map("getFixingTime", fxSpotRateSource -> fxSpotRateSource.getFixingTime()).get())).build())).get()).build());
            return Optional.ofNullable(quantityMultiplier).map(o -> o.prune()).orElse(null);
        }
    }
}

