/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.creditdefaultswap.functions;

import cdm.ingest.fpml.confirmation.pricequantity.functions.MapNotionalAmountToQuantityWithLocation;
import cdm.observable.asset.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.cd.ProtectionTerms;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapProtectionTermsToPriceQuantityDefault.class)
public abstract class MapProtectionTermsToPriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapNotionalAmountToQuantityWithLocation mapNotionalAmountToQuantityWithLocation;

    public PriceQuantity evaluate(List<? extends ProtectionTerms> fpmlProtectionTerms) {
        PriceQuantity priceQuantity;
        PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = this.doEvaluate(fpmlProtectionTerms);
        if (priceQuantityBuilder == null) {
            priceQuantity = null;
        } else {
            priceQuantity = priceQuantityBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(List<? extends ProtectionTerms> var1);

    public static class MapProtectionTermsToPriceQuantityDefault
    extends MapProtectionTermsToPriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(List<? extends ProtectionTerms> fpmlProtectionTerms) {
            if (fpmlProtectionTerms == null) {
                fpmlProtectionTerms = Collections.emptyList();
            }
            PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
            return this.assignOutput(priceQuantity, fpmlProtectionTerms);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, List<? extends ProtectionTerms> fpmlProtectionTerms) {
            priceQuantity = (PriceQuantity.PriceQuantityBuilder)this.toBuilder(PriceQuantity.builder().setQuantity(MapperC.of(fpmlProtectionTerms).mapItem(item -> MapperS.of((Object)this.mapNotionalAmountToQuantityWithLocation.evaluate((BigDecimal)item.map("getCalculationAmount", protectionTerms -> protectionTerms.getCalculationAmount()).map("getAmount", money -> money.getAmount()).get(), Collections.emptyList(), (Currency)item.map("getCalculationAmount", protectionTerms -> protectionTerms.getCalculationAmount()).map("getCurrency", money -> money.getCurrency()).get(), null))).getMulti()).build());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }
    }
}

