/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.correlationswap.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.product.correlationswap.functions.MapCorrelationSwapPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.correlation.swaps.CorrelationSwap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCorrelationSwapEconomicTermsDefault.class)
public abstract class MapCorrelationSwapEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCorrelationSwapPayout mapCorrelationSwapPayout;

    public EconomicTerms evaluate(CorrelationSwap fpmlCorrelationSwap, List<? extends Counterparty> cdmCounterpartyList) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlCorrelationSwap, cdmCounterpartyList);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(CorrelationSwap var1, List<? extends Counterparty> var2);

    public static class MapCorrelationSwapEconomicTermsDefault
    extends MapCorrelationSwapEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(CorrelationSwap fpmlCorrelationSwap, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlCorrelationSwap, cdmCounterpartyList);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, CorrelationSwap fpmlCorrelationSwap, List<? extends Counterparty> cdmCounterpartyList) {
            Payout payout = this.mapCorrelationSwapPayout.evaluate(fpmlCorrelationSwap, cdmCounterpartyList);
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setPayout(payout == null ? Collections.emptyList() : Collections.singletonList(payout)).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

