/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.commodityoption.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.datetime.functions.MapAdjustableOrRelativeDate;
import cdm.ingest.fpml.confirmation.product.commodityoption.functions.MapCommodityOptionPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.com.CommodityOption;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCommodityOptionEconomicTermsDefault.class)
public abstract class MapCommodityOptionEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustableOrRelativeDate mapAdjustableOrRelativeDate;
    @Inject
    protected MapCommodityOptionPayout mapCommodityOptionPayout;

    public EconomicTerms evaluate(CommodityOption fpmlCommodityOption, List<? extends Counterparty> cdmCounterpartyList) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlCommodityOption, cdmCounterpartyList);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(CommodityOption var1, List<? extends Counterparty> var2);

    public static class MapCommodityOptionEconomicTermsDefault
    extends MapCommodityOptionEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(CommodityOption fpmlCommodityOption, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlCommodityOption, cdmCounterpartyList);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, CommodityOption fpmlCommodityOption, List<? extends Counterparty> cdmCounterpartyList) {
            Payout payout = this.mapCommodityOptionPayout.evaluate(fpmlCommodityOption, cdmCounterpartyList);
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setEffectiveDate(this.mapAdjustableOrRelativeDate.evaluate((AdjustableOrRelativeDate)MapperS.of((Object)fpmlCommodityOption).map("getCommodityFinancialOptionModel", commodityOption -> commodityOption.getCommodityFinancialOptionModel()).map("getCommodityOptionFeaturesModel", commodityFinancialOptionModel -> commodityFinancialOptionModel.getCommodityOptionFeaturesModel()).map("getEffectiveDate", commodityOptionFeaturesModel -> commodityOptionFeaturesModel.getEffectiveDate()).get())).setPayout(payout == null ? Collections.emptyList() : Collections.singletonList(payout)).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

