/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.bondoption.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.product.bondoption.functions.MapBondOptionPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.bond.option.BondOption;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapBondOptionEconomicTermsDefault.class)
public abstract class MapBondOptionEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapBondOptionPayout mapBondOptionPayout;

    public EconomicTerms evaluate(BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlBondOption, cdmCounterpartyList);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(BondOption var1, List<? extends Counterparty> var2);

    public static class MapBondOptionEconomicTermsDefault
    extends MapBondOptionEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlBondOption, cdmCounterpartyList);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
            Payout payout = this.mapBondOptionPayout.evaluate(fpmlBondOption, cdmCounterpartyList);
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setPayout(payout == null ? Collections.emptyList() : Collections.singletonList(payout)).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

