/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.UnitType;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.template.OptionStrike;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapOptionStrikePriceDefault.class)
public abstract class MapOptionStrikePrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public OptionStrike evaluate(BigDecimal fpmlStrikePrice, BigDecimal fpmlStrikePercentage, UnitType unit, UnitType perUnitOf) {
        OptionStrike optionStrike;
        OptionStrike.OptionStrikeBuilder optionStrikeBuilder = this.doEvaluate(fpmlStrikePrice, fpmlStrikePercentage, unit, perUnitOf);
        if (optionStrikeBuilder == null) {
            optionStrike = null;
        } else {
            optionStrike = optionStrikeBuilder.build();
            this.objectValidator.validate(OptionStrike.class, (RosettaModelObject)optionStrike);
        }
        return optionStrike;
    }

    protected abstract OptionStrike.OptionStrikeBuilder doEvaluate(BigDecimal var1, BigDecimal var2, UnitType var3, UnitType var4);

    public static class MapOptionStrikePriceDefault
    extends MapOptionStrikePrice {
        @Override
        protected OptionStrike.OptionStrikeBuilder doEvaluate(BigDecimal fpmlStrikePrice, BigDecimal fpmlStrikePercentage, UnitType unit, UnitType perUnitOf) {
            OptionStrike.OptionStrikeBuilder optionStrike = OptionStrike.builder();
            return this.assignOutput(optionStrike, fpmlStrikePrice, fpmlStrikePercentage, unit, perUnitOf);
        }

        protected OptionStrike.OptionStrikeBuilder assignOutput(OptionStrike.OptionStrikeBuilder optionStrike, BigDecimal fpmlStrikePrice, BigDecimal fpmlStrikePercentage, UnitType unit, UnitType perUnitOf) {
            optionStrike = ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlStrikePrice)).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlStrikePercentage))).getOrDefault(Boolean.valueOf(false)) != false ? (OptionStrike.OptionStrikeBuilder)this.toBuilder(OptionStrike.builder().setStrikePrice(Price.builder().setValue((BigDecimal)MapperS.of((Object)fpmlStrikePrice).getOrDefault((Object)fpmlStrikePercentage)).setUnit(unit).setPerUnitOf(perUnitOf).setPriceType(PriceTypeEnum.ASSET_PRICE).build()).build()) : null;
            return Optional.ofNullable(optionStrike).map(o -> o.prune()).orElse(null);
        }
    }
}

