/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.DatedValue;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Measure;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapScheduleToDatedValueList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Step;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCurrencyAmountToQuantityDefault.class)
public abstract class MapCurrencyAmountToQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapScheduleToDatedValueList mapScheduleToDatedValueList;

    public NonNegativeQuantitySchedule evaluate(BigDecimal fpmlNotionalAmount, List<? extends Step> fpmlStepList, Currency fpmlCurrency, FinancialUnitEnum fpmlFinancialUnit) {
        NonNegativeQuantitySchedule nonNegativeQuantitySchedule;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder nonNegativeQuantityScheduleBuilder = this.doEvaluate(fpmlNotionalAmount, fpmlStepList, fpmlCurrency, fpmlFinancialUnit);
        if (nonNegativeQuantityScheduleBuilder == null) {
            nonNegativeQuantitySchedule = null;
        } else {
            nonNegativeQuantitySchedule = nonNegativeQuantityScheduleBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)nonNegativeQuantitySchedule);
        }
        return nonNegativeQuantitySchedule;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(BigDecimal var1, List<? extends Step> var2, Currency var3, FinancialUnitEnum var4);

    public static class MapCurrencyAmountToQuantityDefault
    extends MapCurrencyAmountToQuantity {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(BigDecimal fpmlNotionalAmount, List<? extends Step> fpmlStepList, Currency fpmlCurrency, FinancialUnitEnum fpmlFinancialUnit) {
            if (fpmlStepList == null) {
                fpmlStepList = Collections.emptyList();
            }
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder nonNegativeQuantitySchedule = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(nonNegativeQuantitySchedule, fpmlNotionalAmount, fpmlStepList, fpmlCurrency, fpmlFinancialUnit);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder nonNegativeQuantitySchedule, BigDecimal fpmlNotionalAmount, List<? extends Step> fpmlStepList, Currency fpmlCurrency, FinancialUnitEnum fpmlFinancialUnit) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlNotionalAmount)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                FinancialUnitEnum ifThenElseResult = null;
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Object)fpmlFinancialUnit))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = fpmlFinancialUnit;
                }
                nonNegativeQuantitySchedule = (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder(NonNegativeQuantitySchedule.builder().setValue(fpmlNotionalAmount).setDatedValue(new ArrayList<DatedValue>(this.mapScheduleToDatedValueList.evaluate(fpmlStepList))).setUnit(UnitType.builder().setCurrency(this.mapCurrency.evaluate(fpmlCurrency)).build()).setMultiplier(Measure.builder().setValue(fpmlNotionalAmount).setUnit(UnitType.builder().setFinancialUnit(ifThenElseResult).build()).build()).build());
            } else {
                nonNegativeQuantitySchedule = null;
            }
            return Optional.ofNullable(nonNegativeQuantitySchedule).map(o -> o.prune()).orElse(null);
        }
    }
}

