/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapAssetCommodity;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapIdentifiedAssetToAssetListedDerivative;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapIdentifiedAssetToAssetSecurity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.Commodity;
import fpml.consolidated.asset.IdentifiedAsset;
import fpml.consolidated.shared.ExchangeId;
import fpml.custom.functions.ToAssetChoice;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapAssetDefault.class)
public abstract class MapAsset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAssetCommodity mapAssetCommodity;
    @Inject
    protected MapIdentifiedAssetToAssetListedDerivative mapIdentifiedAssetToAssetListedDerivative;
    @Inject
    protected MapIdentifiedAssetToAssetSecurity mapIdentifiedAssetToAssetSecurity;
    @Inject
    protected ToAssetChoice toAssetChoice;

    public Asset evaluate(fpml.consolidated.asset.Asset fpmlAsset) {
        Asset asset;
        Asset.AssetBuilder assetBuilder = this.doEvaluate(fpmlAsset);
        if (assetBuilder == null) {
            asset = null;
        } else {
            asset = assetBuilder.build();
            this.objectValidator.validate(Asset.class, (RosettaModelObject)asset);
        }
        return asset;
    }

    protected abstract Asset.AssetBuilder doEvaluate(fpml.consolidated.asset.Asset var1);

    public static class MapAssetDefault
    extends MapAsset {
        @Override
        protected Asset.AssetBuilder doEvaluate(fpml.consolidated.asset.Asset fpmlAsset) {
            Asset.AssetBuilder asset = Asset.builder();
            return this.assignOutput(asset, fpmlAsset);
        }

        protected Asset.AssetBuilder assignOutput(Asset.AssetBuilder asset, fpml.consolidated.asset.Asset fpmlAsset) {
            MapperS switchArgument = MapperS.of((Object)this.toAssetChoice.evaluate(fpmlAsset));
            if (switchArgument.get() == null) {
                asset = null;
            } else if (switchArgument.map("getExchangeTradedFund", assetChoice -> assetChoice.getExchangeTradedFund()).get() != null) {
                MapperS exchangeTradedFund = switchArgument.map("getExchangeTradedFund", assetChoice -> assetChoice.getExchangeTradedFund());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapIdentifiedAssetToAssetListedDerivative.evaluate((IdentifiedAsset)exchangeTradedFund.get(), (ExchangeId)exchangeTradedFund.map("getExchangeId", _exchangeTradedFund -> _exchangeTradedFund.getExchangeId()).get(), exchangeTradedFund.map("getExchangeIdentifierModel", _exchangeTradedFund -> _exchangeTradedFund.getExchangeIdentifierModel()).mapC("getRelatedExchangeId", exchangeIdentifierModel -> exchangeIdentifierModel.getRelatedExchangeId()).getMulti(), InstrumentTypeEnum.FUND));
            } else if (switchArgument.map("getExchangeTradedContract", assetChoice -> assetChoice.getExchangeTradedContract()).get() != null) {
                MapperS exchangeTradedContract = switchArgument.map("getExchangeTradedContract", assetChoice -> assetChoice.getExchangeTradedContract());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapIdentifiedAssetToAssetListedDerivative.evaluate((IdentifiedAsset)exchangeTradedContract.get(), (ExchangeId)exchangeTradedContract.map("getExchangeId", _exchangeTradedContract -> _exchangeTradedContract.getExchangeId()).get(), exchangeTradedContract.map("getExchangeIdentifierModel", _exchangeTradedContract -> _exchangeTradedContract.getExchangeIdentifierModel()).mapC("getRelatedExchangeId", exchangeIdentifierModel -> exchangeIdentifierModel.getRelatedExchangeId()).getMulti(), InstrumentTypeEnum.LISTED_DERIVATIVE));
            } else if (switchArgument.map("getLoan", assetChoice -> assetChoice.getLoan()).get() != null) {
                MapperS loan = switchArgument.map("getLoan", assetChoice -> assetChoice.getLoan());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapIdentifiedAssetToAssetSecurity.evaluate((IdentifiedAsset)loan.get(), (ExchangeId)loan.map("getExchangeId", _loan -> _loan.getExchangeId()).get(), Collections.emptyList(), InstrumentTypeEnum.DEBT));
            } else if (switchArgument.map("getConvertibleBond", assetChoice -> assetChoice.getConvertibleBond()).get() != null) {
                MapperS convertibleBond = switchArgument.map("getConvertibleBond", assetChoice -> assetChoice.getConvertibleBond());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapIdentifiedAssetToAssetSecurity.evaluate((IdentifiedAsset)convertibleBond.get(), null, Collections.emptyList(), InstrumentTypeEnum.DEBT));
            } else if (switchArgument.map("getBond", assetChoice -> assetChoice.getBond()).get() != null) {
                MapperS bond = switchArgument.map("getBond", assetChoice -> assetChoice.getBond());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapIdentifiedAssetToAssetSecurity.evaluate((IdentifiedAsset)bond.get(), null, Collections.emptyList(), InstrumentTypeEnum.DEBT));
            } else if (switchArgument.map("getEquity", assetChoice -> assetChoice.getEquity()).get() != null) {
                MapperS equity = switchArgument.map("getEquity", assetChoice -> assetChoice.getEquity());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapIdentifiedAssetToAssetSecurity.evaluate((IdentifiedAsset)equity.get(), (ExchangeId)equity.map("getExchangeId", _equity -> _equity.getExchangeId()).get(), equity.map("getExchangeIdentifierModel", _equity -> _equity.getExchangeIdentifierModel()).mapC("getRelatedExchangeId", exchangeIdentifierModel -> exchangeIdentifierModel.getRelatedExchangeId()).getMulti(), InstrumentTypeEnum.EQUITY));
            } else if (switchArgument.map("getCommodity", assetChoice -> assetChoice.getCommodity()).get() != null) {
                MapperS commodity = switchArgument.map("getCommodity", assetChoice -> assetChoice.getCommodity());
                asset = (Asset.AssetBuilder)this.toBuilder(this.mapAssetCommodity.evaluate((Commodity)commodity.get()));
            } else {
                asset = null;
            }
            return Optional.ofNullable(asset).map(o -> o.prune()).orElse(null);
        }
    }
}

