/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.ingest.fpml.confirmation.party.functions.MapCounterpartyRoleEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.ird.PrincipalExchange;
import fpml.consolidated.shared.PayerReceiverModel;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapPrincipalPayerReceiverDefault.class)
public abstract class MapPrincipalPayerReceiver
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCounterpartyRoleEnum mapCounterpartyRoleEnum;

    public PayerReceiver evaluate(PrincipalExchange fpmlPrincipalExchange, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
        PayerReceiver payerReceiver;
        PayerReceiver.PayerReceiverBuilder payerReceiverBuilder = this.doEvaluate(fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList);
        if (payerReceiverBuilder == null) {
            payerReceiver = null;
        } else {
            payerReceiver = payerReceiverBuilder.build();
            this.objectValidator.validate(PayerReceiver.class, (RosettaModelObject)payerReceiver);
        }
        return payerReceiver;
    }

    protected abstract PayerReceiver.PayerReceiverBuilder doEvaluate(PrincipalExchange var1, PayerReceiverModel var2, List<? extends Counterparty> var3);

    protected abstract MapperS<CounterpartyRoleEnum> payer(PrincipalExchange var1, PayerReceiverModel var2, List<? extends Counterparty> var3);

    protected abstract MapperS<CounterpartyRoleEnum> receiver(PrincipalExchange var1, PayerReceiverModel var2, List<? extends Counterparty> var3);

    public static class MapPrincipalPayerReceiverDefault
    extends MapPrincipalPayerReceiver {
        @Override
        protected PayerReceiver.PayerReceiverBuilder doEvaluate(PrincipalExchange fpmlPrincipalExchange, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            PayerReceiver.PayerReceiverBuilder payerReceiver = PayerReceiver.builder();
            return this.assignOutput(payerReceiver, fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList);
        }

        protected PayerReceiver.PayerReceiverBuilder assignOutput(PayerReceiver.PayerReceiverBuilder payerReceiver, PrincipalExchange fpmlPrincipalExchange, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            payerReceiver = ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)fpmlPrincipalExchange).map("getPrincipalExchangeAmount", principalExchange -> principalExchange.getPrincipalExchangeAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (PayerReceiver.PayerReceiverBuilder)this.toBuilder(PayerReceiver.builder().setPayer((CounterpartyRoleEnum)((Object)this.payer(fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList).get())).setReceiver((CounterpartyRoleEnum)((Object)this.receiver(fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList).get())).build()) : (PayerReceiver.PayerReceiverBuilder)this.toBuilder(PayerReceiver.builder().setPayer((CounterpartyRoleEnum)((Object)this.receiver(fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList).get())).setReceiver((CounterpartyRoleEnum)((Object)this.payer(fpmlPrincipalExchange, fpmlPayerReceiverModel, cdmCounterpartyList).get())).build());
            return Optional.ofNullable(payerReceiver).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<CounterpartyRoleEnum> payer(PrincipalExchange fpmlPrincipalExchange, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)((Object)this.mapCounterpartyRoleEnum.evaluate((String)MapperS.of((Object)fpmlPayerReceiverModel).map("getPayerModel", payerReceiverModel -> payerReceiverModel.getPayerModel()).map("getPayerPartyReference", payerModel -> payerModel.getPayerPartyReference()).map("getHref", partyReference -> partyReference.getHref()).get(), cdmCounterpartyList)));
        }

        @Override
        protected MapperS<CounterpartyRoleEnum> receiver(PrincipalExchange fpmlPrincipalExchange, PayerReceiverModel fpmlPayerReceiverModel, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)((Object)this.mapCounterpartyRoleEnum.evaluate((String)MapperS.of((Object)fpmlPayerReceiverModel).map("getReceiverModel", payerReceiverModel -> payerReceiverModel.getReceiverModel()).map("getReceiverPartyReference", receiverModel -> receiverModel.getReceiverPartyReference()).map("getHref", partyReference -> partyReference.getHref()).get(), cdmCounterpartyList)));
        }
    }
}

