/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapStringWithScheme;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Money;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapMoneyToTransferQuantityDefault.class)
public abstract class MapMoneyToTransferQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapStringWithScheme mapStringWithScheme;

    public NonNegativeQuantity evaluate(Money fpmlMoney) {
        NonNegativeQuantity quantity;
        NonNegativeQuantity.NonNegativeQuantityBuilder quantityBuilder = this.doEvaluate(fpmlMoney);
        if (quantityBuilder == null) {
            quantity = null;
        } else {
            quantity = quantityBuilder.build();
            this.objectValidator.validate(NonNegativeQuantity.class, (RosettaModelObject)quantity);
        }
        return quantity;
    }

    protected abstract NonNegativeQuantity.NonNegativeQuantityBuilder doEvaluate(Money var1);

    public static class MapMoneyToTransferQuantityDefault
    extends MapMoneyToTransferQuantity {
        @Override
        protected NonNegativeQuantity.NonNegativeQuantityBuilder doEvaluate(Money fpmlMoney) {
            NonNegativeQuantity.NonNegativeQuantityBuilder quantity = NonNegativeQuantity.builder();
            return this.assignOutput(quantity, fpmlMoney);
        }

        protected NonNegativeQuantity.NonNegativeQuantityBuilder assignOutput(NonNegativeQuantity.NonNegativeQuantityBuilder quantity, Money fpmlMoney) {
            quantity = (NonNegativeQuantity.NonNegativeQuantityBuilder)this.toBuilder(NonNegativeQuantity.builder().setValue((BigDecimal)MapperS.of((Object)fpmlMoney).map("getAmount", money -> money.getAmount()).get()).setUnit(UnitType.builder().setCurrency(this.mapStringWithScheme.evaluate((String)MapperS.of((Object)fpmlMoney).map("getCurrency", money -> money.getCurrency()).map("getValue", currency -> currency.getValue()).get(), (String)MapperS.of((Object)fpmlMoney).map("getCurrency", money -> money.getCurrency()).map("getCurrencyScheme", currency -> currency.getCurrencyScheme()).get())).build()).build());
            return Optional.ofNullable(quantity).map(o -> o.prune()).orElse(null);
        }
    }
}

