/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.party.functions;

import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.ingest.fpml.confirmation.party.functions.MapPartyReference;
import cdm.ingest.fpml.confirmation.party.functions.MapRelatedPartyToPartyRole;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.doc.PartyTradeInformation;
import fpml.consolidated.doc.Trade;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapPartyRoleListDefault.class)
public abstract class MapPartyRoleList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapPartyReference mapPartyReference;
    @Inject
    protected MapRelatedPartyToPartyRole mapRelatedPartyToPartyRole;

    public List<? extends PartyRole> evaluate(Trade fpmlTrade) {
        List partyRoleList;
        List<PartyRole.PartyRoleBuilder> partyRoleListBuilder = this.doEvaluate(fpmlTrade);
        if (partyRoleListBuilder == null) {
            partyRoleList = null;
        } else {
            partyRoleList = partyRoleListBuilder.stream().map(PartyRole::build).collect(Collectors.toList());
            this.objectValidator.validate(PartyRole.class, partyRoleList);
        }
        return partyRoleList;
    }

    protected abstract List<PartyRole.PartyRoleBuilder> doEvaluate(Trade var1);

    public static class MapPartyRoleListDefault
    extends MapPartyRoleList {
        @Override
        protected List<PartyRole.PartyRoleBuilder> doEvaluate(Trade fpmlTrade) {
            ArrayList<PartyRole.PartyRoleBuilder> partyRoleList = new ArrayList<PartyRole.PartyRoleBuilder>();
            return this.assignOutput(partyRoleList, fpmlTrade);
        }

        protected List<PartyRole.PartyRoleBuilder> assignOutput(List<PartyRole.PartyRoleBuilder> partyRoleList, Trade fpmlTrade) {
            partyRoleList.addAll(this.toBuilder(MapperS.of((Object)fpmlTrade).mapC("getDeterminingParty", trade -> trade.getDeterminingParty()).mapItem(item -> MapperS.of((Object)PartyRole.builder().setPartyReference(this.mapPartyReference.evaluate((String)item.map("getHref", partyReference -> partyReference.getHref()).get())).setRole(PartyRoleEnum.DETERMINING_PARTY).build())).getMulti()));
            partyRoleList.addAll(this.toBuilder(MapperS.of((Object)fpmlTrade).map("getBarrierDeterminationAgent", trade -> trade.getBarrierDeterminationAgent()).mapSingleToItem(item -> MapperS.of((Object)PartyRole.builder().setPartyReference(this.mapPartyReference.evaluate((String)item.map("getHref", partyReference -> partyReference.getHref()).get())).setRole(PartyRoleEnum.BARRIER_DETERMINATION_AGENT).build())).getMulti()));
            partyRoleList.addAll(this.toBuilder(MapperS.of((Object)fpmlTrade).mapC("getHedgingParty", trade -> trade.getHedgingParty()).mapItem(item -> MapperS.of((Object)PartyRole.builder().setPartyReference(this.mapPartyReference.evaluate((String)item.map("getHref", partyReference -> partyReference.getHref()).get())).setRole(PartyRoleEnum.HEDGING_PARTY).build())).getMulti()));
            partyRoleList.addAll(this.toBuilder(MapperS.of((Object)fpmlTrade).mapC("getBrokerPartyReference", trade -> trade.getBrokerPartyReference()).mapItem(item -> MapperS.of((Object)PartyRole.builder().setPartyReference(this.mapPartyReference.evaluate((String)item.map("getHref", partyReference -> partyReference.getHref()).get())).setRole(PartyRoleEnum.ARRANGING_BROKER).build())).getMulti()));
            MapperListOfLists thenArg = MapperS.of((Object)fpmlTrade).map("getTradeHeader", trade -> trade.getTradeHeader()).mapC("getPartyTradeInformation", tradeHeader -> tradeHeader.getPartyTradeInformation()).mapItemToList(item -> MapperC.of(this.mapRelatedPartyToPartyRole.evaluate((PartyTradeInformation)item.get())));
            partyRoleList.addAll(this.toBuilder(thenArg.flattenList().getMulti()));
            return Optional.ofNullable(partyRoleList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

