/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.party.functions;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Account;
import fpml.consolidated.shared.BuyerSellerModel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapBuyerSellerToAccountPartyReferenceDefault.class)
public abstract class MapBuyerSellerToAccountPartyReference
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ReferenceWithMetaParty evaluate(Account fpmlAccount, List<? extends BuyerSellerModel> fpmlBuyerSellerModelModelList) {
        ReferenceWithMetaParty partyReference;
        ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReferenceBuilder = this.doEvaluate(fpmlAccount, fpmlBuyerSellerModelModelList);
        if (partyReferenceBuilder == null) {
            partyReference = null;
        } else {
            partyReference = partyReferenceBuilder.build();
            this.objectValidator.validate(ReferenceWithMetaParty.class, (RosettaModelObject)partyReference);
        }
        return partyReference;
    }

    protected abstract ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder doEvaluate(Account var1, List<? extends BuyerSellerModel> var2);

    protected abstract MapperS<String> buyerPartyReference(Account var1, List<? extends BuyerSellerModel> var2);

    protected abstract MapperS<String> sellerPartyReference(Account var1, List<? extends BuyerSellerModel> var2);

    public static class MapBuyerSellerToAccountPartyReferenceDefault
    extends MapBuyerSellerToAccountPartyReference {
        @Override
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder doEvaluate(Account fpmlAccount, List<? extends BuyerSellerModel> fpmlBuyerSellerModelModelList) {
            if (fpmlBuyerSellerModelModelList == null) {
                fpmlBuyerSellerModelModelList = Collections.emptyList();
            }
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference = ReferenceWithMetaParty.builder();
            return this.assignOutput(partyReference, fpmlAccount, fpmlBuyerSellerModelModelList);
        }

        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder assignOutput(ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference, Account fpmlAccount, List<? extends BuyerSellerModel> fpmlBuyerSellerModelModelList) {
            partyReference.setExternalReference((String)this.buyerPartyReference(fpmlAccount, fpmlBuyerSellerModelModelList).getOrDefault((Object)((String)this.sellerPartyReference(fpmlAccount, fpmlBuyerSellerModelModelList).get())));
            return Optional.ofNullable(partyReference).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<String> buyerPartyReference(Account fpmlAccount, List<? extends BuyerSellerModel> fpmlBuyerSellerModelModelList) {
            MapperC thenArg0 = MapperC.of(fpmlBuyerSellerModelModelList).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getBuyerAccountReference", buyerSellerModel -> buyerSellerModel.getBuyerAccountReference()).map("getHref", accountReference -> accountReference.getHref()), (Mapper)MapperS.of((Object)fpmlAccount).map("getId", account -> account.getId()), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getBuyerAccountReference", buyerSellerModel -> buyerSellerModel.getBuyerAccountReference()).map("getHref", accountReference -> accountReference.getHref()));
            return MapperS.of((Object)((String)ExpressionOperators.distinct((Mapper)thenArg1).get()));
        }

        @Override
        protected MapperS<String> sellerPartyReference(Account fpmlAccount, List<? extends BuyerSellerModel> fpmlBuyerSellerModelModelList) {
            MapperC thenArg0 = MapperC.of(fpmlBuyerSellerModelModelList).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getSellerAccountReference", buyerSellerModel -> buyerSellerModel.getSellerAccountReference()).map("getHref", accountReference -> accountReference.getHref()), (Mapper)MapperS.of((Object)fpmlAccount).map("getId", account -> account.getId()), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getSellerAccountReference", buyerSellerModel -> buyerSellerModel.getSellerAccountReference()).map("getHref", accountReference -> accountReference.getHref()));
            return MapperS.of((Object)((String)ExpressionOperators.distinct((Mapper)thenArg1).get()));
        }
    }
}

