/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.datetime.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Period;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapPeriodToFrequencyDefault.class)
public abstract class MapPeriodToFrequency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Frequency evaluate(Period fpmlPeriod) {
        Frequency frequency;
        Frequency.FrequencyBuilder frequencyBuilder = this.doEvaluate(fpmlPeriod);
        if (frequencyBuilder == null) {
            frequency = null;
        } else {
            frequency = frequencyBuilder.build();
            this.objectValidator.validate(Frequency.class, (RosettaModelObject)frequency);
        }
        return frequency;
    }

    protected abstract Frequency.FrequencyBuilder doEvaluate(Period var1);

    public static class MapPeriodToFrequencyDefault
    extends MapPeriodToFrequency {
        @Override
        protected Frequency.FrequencyBuilder doEvaluate(Period fpmlPeriod) {
            Frequency.FrequencyBuilder frequency = Frequency.builder();
            return this.assignOutput(frequency, fpmlPeriod);
        }

        protected Frequency.FrequencyBuilder assignOutput(Frequency.FrequencyBuilder frequency, Period fpmlPeriod) {
            frequency = (Frequency.FrequencyBuilder)this.toBuilder(Frequency.builder().setPeriodMultiplier((Integer)MapperS.of((Object)fpmlPeriod).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).get()).setPeriod((PeriodExtendedEnum)((Object)MapperS.of((Object)fpmlPeriod).map("getPeriod", period -> period.getPeriod()).checkedMap("to-enum", e -> PeriodExtendedEnum.valueOf(e.name()), IllegalArgumentException.class).get())).build());
            return Optional.ofNullable(frequency).map(o -> o.prune()).orElse(null);
        }
    }
}

