/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.Valuation;
import cdm.event.common.meta.ValuationInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationInstruction", builder=ValuationInstructionBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ValuationInstruction", model="cdm", builder=ValuationInstructionBuilderImpl.class, version="7.0.0-dev.52")
public interface ValuationInstruction
extends RosettaModelObject {
    public static final ValuationInstructionMeta metaData = new ValuationInstructionMeta();

    public List<? extends Valuation> getValuation();

    public Boolean getReplace();

    public ValuationInstruction build();

    public ValuationInstructionBuilder toBuilder();

    public static ValuationInstructionBuilder builder() {
        return new ValuationInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationInstruction> getType() {
        return ValuationInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuation"), processor, Valuation.class, this.getValuation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("replace"), Boolean.class, (Object)this.getReplace(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ValuationInstructionBuilderImpl
    implements ValuationInstructionBuilder {
        protected List<Valuation.ValuationBuilder> valuation = new ArrayList<Valuation.ValuationBuilder>();
        protected Boolean replace;

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public List<? extends Valuation.ValuationBuilder> getValuation() {
            return this.valuation;
        }

        @Override
        public Valuation.ValuationBuilder getOrCreateValuation(int index) {
            if (this.valuation == null) {
                this.valuation = new ArrayList<Valuation.ValuationBuilder>();
            }
            return (Valuation.ValuationBuilder)this.getIndex(this.valuation, index, () -> {
                Valuation.ValuationBuilder newValuation = Valuation.builder();
                return newValuation;
            });
        }

        @Override
        @RosettaAttribute(value="replace", isRequired=true)
        @RuneAttribute(value="replace", isRequired=true)
        public Boolean getReplace() {
            return this.replace;
        }

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public ValuationInstructionBuilder addValuation(Valuation _valuation) {
            if (_valuation != null) {
                this.valuation.add(_valuation.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationInstructionBuilder addValuation(Valuation _valuation, int idx) {
            this.getIndex(this.valuation, idx, () -> _valuation.toBuilder());
            return this;
        }

        @Override
        public ValuationInstructionBuilder addValuation(List<? extends Valuation> valuations) {
            if (valuations != null) {
                for (Valuation valuation : valuations) {
                    this.valuation.add(valuation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="valuation")
        public ValuationInstructionBuilder setValuation(List<? extends Valuation> valuations) {
            this.valuation = valuations == null ? new ArrayList<Valuation.ValuationBuilder>() : (List)valuations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="replace", isRequired=true)
        @RuneAttribute(value="replace", isRequired=true)
        public ValuationInstructionBuilder setReplace(Boolean _replace) {
            this.replace = _replace == null ? null : _replace;
            return this;
        }

        @Override
        public ValuationInstruction build() {
            return new ValuationInstructionImpl(this);
        }

        @Override
        public ValuationInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationInstructionBuilder prune() {
            this.valuation = this.valuation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getValuation() != null && this.getValuation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReplace() != null;
        }

        public ValuationInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationInstructionBuilder o = (ValuationInstructionBuilder)other;
            merger.mergeRosetta(this.getValuation(), o.getValuation(), this::getOrCreateValuation);
            merger.mergeBasic((Object)this.getReplace(), (Object)o.getReplace(), this::setReplace, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.valuation, _that.getValuation())) {
                return false;
            }
            return Objects.equals(this.replace, _that.getReplace());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuation != null ? this.valuation.hashCode() : 0);
            _result = 31 * _result + (this.replace != null ? this.replace.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationInstructionBuilder {valuation=" + this.valuation + ", replace=" + this.replace + '}';
        }
    }

    public static interface ValuationInstructionBuilder
    extends ValuationInstruction,
    RosettaModelObjectBuilder {
        public Valuation.ValuationBuilder getOrCreateValuation(int var1);

        public List<? extends Valuation.ValuationBuilder> getValuation();

        public ValuationInstructionBuilder addValuation(Valuation var1);

        public ValuationInstructionBuilder addValuation(Valuation var1, int var2);

        public ValuationInstructionBuilder addValuation(List<? extends Valuation> var1);

        public ValuationInstructionBuilder setValuation(List<? extends Valuation> var1);

        public ValuationInstructionBuilder setReplace(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuation"), processor, Valuation.ValuationBuilder.class, this.getValuation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("replace"), Boolean.class, (Object)this.getReplace(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ValuationInstructionBuilder prune();
    }

    public static class ValuationInstructionImpl
    implements ValuationInstruction {
        private final List<? extends Valuation> valuation;
        private final Boolean replace;

        protected ValuationInstructionImpl(ValuationInstructionBuilder builder) {
            this.valuation = Optional.ofNullable(builder.getValuation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.replace = builder.getReplace();
        }

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public List<? extends Valuation> getValuation() {
            return this.valuation;
        }

        @Override
        @RosettaAttribute(value="replace", isRequired=true)
        @RuneAttribute(value="replace", isRequired=true)
        public Boolean getReplace() {
            return this.replace;
        }

        @Override
        public ValuationInstruction build() {
            return this;
        }

        @Override
        public ValuationInstructionBuilder toBuilder() {
            ValuationInstructionBuilder builder = ValuationInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationInstructionBuilder builder) {
            Optional.ofNullable(this.getValuation()).ifPresent(builder::setValuation);
            Optional.ofNullable(this.getReplace()).ifPresent(builder::setReplace);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.valuation, _that.getValuation())) {
                return false;
            }
            return Objects.equals(this.replace, _that.getReplace());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuation != null ? this.valuation.hashCode() : 0);
            _result = 31 * _result + (this.replace != null ? this.replace.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationInstruction {valuation=" + this.valuation + ", replace=" + this.replace + '}';
        }
    }
}

