/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party.validation.datarule;

import cdm.base.staticdata.party.NaturalPerson;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NaturalPersonNameOrIdChoice")
@ImplementedBy(value=Default.class)
public interface NaturalPersonNameOrIdChoice
extends Validator<NaturalPerson> {
    public static final String NAME = "NaturalPersonNameOrIdChoice";
    public static final String DEFINITION = "(firstName exists and surname exists) or personId exists";

    public static class NoOp
    implements NaturalPersonNameOrIdChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NaturalPerson naturalPerson) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NaturalPersonNameOrIdChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NaturalPerson naturalPerson) {
            ComparisonResult result = this.executeDataRule(naturalPerson);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NaturalPersonNameOrIdChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NaturalPerson", (RosettaPath)path, (String)NaturalPersonNameOrIdChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NaturalPersonNameOrIdChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NaturalPerson", (RosettaPath)path, (String)NaturalPersonNameOrIdChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(NaturalPerson naturalPerson) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)naturalPerson).map("getFirstName", _naturalPerson -> _naturalPerson.getFirstName())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)naturalPerson).map("getSurname", _naturalPerson -> _naturalPerson.getSurname()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)naturalPerson).mapC("getPersonId", _naturalPerson -> _naturalPerson.getPersonId())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

