/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.InstrumentBase;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.meta.LoanMeta;
import cdm.base.staticdata.party.LegalEntity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Loan", builder=LoanBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="Loan", model="cdm", builder=LoanBuilderImpl.class, version="7.0.0-dev.52")
public interface Loan
extends InstrumentBase {
    public static final LoanMeta metaData = new LoanMeta();

    public List<? extends LegalEntity> getBorrower();

    public FieldWithMetaString getLien();

    public FieldWithMetaString getFacilityType();

    public Date getCreditAgreementDate();

    public FieldWithMetaString getTranche();

    @Override
    public Loan build();

    @Override
    public LoanBuilder toBuilder();

    public static LoanBuilder builder() {
        return new LoanBuilderImpl();
    }

    default public RosettaMetaData<? extends Loan> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Loan> getType() {
        return Loan.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("borrower"), processor, LegalEntity.class, this.getBorrower(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lien"), processor, FieldWithMetaString.class, this.getLien(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityType"), processor, FieldWithMetaString.class, this.getFacilityType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditAgreementDate"), Date.class, (Object)this.getCreditAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tranche"), processor, FieldWithMetaString.class, this.getTranche(), new AttributeMeta[0]);
    }

    public static class LoanBuilderImpl
    extends InstrumentBase.InstrumentBaseBuilderImpl
    implements LoanBuilder {
        protected List<LegalEntity.LegalEntityBuilder> borrower = new ArrayList<LegalEntity.LegalEntityBuilder>();
        protected FieldWithMetaString.FieldWithMetaStringBuilder lien;
        protected FieldWithMetaString.FieldWithMetaStringBuilder facilityType;
        protected Date creditAgreementDate;
        protected FieldWithMetaString.FieldWithMetaStringBuilder tranche;

        @Override
        @RosettaAttribute(value="borrower")
        @RuneAttribute(value="borrower")
        public List<? extends LegalEntity.LegalEntityBuilder> getBorrower() {
            return this.borrower;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateBorrower(int index) {
            if (this.borrower == null) {
                this.borrower = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.borrower, index, () -> {
                LegalEntity.LegalEntityBuilder newBorrower = LegalEntity.builder();
                return newBorrower;
            });
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public FieldWithMetaString.FieldWithMetaStringBuilder getLien() {
            return this.lien;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateLien() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.lien != null ? this.lien : (this.lien = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public FieldWithMetaString.FieldWithMetaStringBuilder getFacilityType() {
            return this.facilityType;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateFacilityType() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.facilityType != null ? this.facilityType : (this.facilityType = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        @RuneAttribute(value="creditAgreementDate")
        public Date getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public FieldWithMetaString.FieldWithMetaStringBuilder getTranche() {
            return this.tranche;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateTranche() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.tranche != null ? this.tranche : (this.tranche = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public LoanBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public LoanBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public LoanBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public LoanBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public LoanBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public LoanBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public LoanBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public LoanBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType", isRequired=true)
        @RuneAttribute(value="instrumentType", isRequired=true)
        public LoanBuilder setInstrumentType(InstrumentTypeEnum _instrumentType) {
            this.instrumentType = _instrumentType == null ? null : _instrumentType;
            return this;
        }

        @Override
        @RosettaAttribute(value="borrower")
        @RuneAttribute(value="borrower")
        public LoanBuilder addBorrower(LegalEntity _borrower) {
            if (_borrower != null) {
                this.borrower.add(_borrower.toBuilder());
            }
            return this;
        }

        @Override
        public LoanBuilder addBorrower(LegalEntity _borrower, int idx) {
            this.getIndex(this.borrower, idx, () -> _borrower.toBuilder());
            return this;
        }

        @Override
        public LoanBuilder addBorrower(List<? extends LegalEntity> borrowers) {
            if (borrowers != null) {
                for (LegalEntity legalEntity : borrowers) {
                    this.borrower.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="borrower")
        public LoanBuilder setBorrower(List<? extends LegalEntity> borrowers) {
            this.borrower = borrowers == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)borrowers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public LoanBuilder setLien(FieldWithMetaString _lien) {
            this.lien = _lien == null ? null : _lien.toBuilder();
            return this;
        }

        @Override
        public LoanBuilder setLienValue(String _lien) {
            this.getOrCreateLien().setValue(_lien);
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public LoanBuilder setFacilityType(FieldWithMetaString _facilityType) {
            this.facilityType = _facilityType == null ? null : _facilityType.toBuilder();
            return this;
        }

        @Override
        public LoanBuilder setFacilityTypeValue(String _facilityType) {
            this.getOrCreateFacilityType().setValue(_facilityType);
            return this;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        @RuneAttribute(value="creditAgreementDate")
        public LoanBuilder setCreditAgreementDate(Date _creditAgreementDate) {
            this.creditAgreementDate = _creditAgreementDate == null ? null : _creditAgreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public LoanBuilder setTranche(FieldWithMetaString _tranche) {
            this.tranche = _tranche == null ? null : _tranche.toBuilder();
            return this;
        }

        @Override
        public LoanBuilder setTrancheValue(String _tranche) {
            this.getOrCreateTranche().setValue(_tranche);
            return this;
        }

        @Override
        public Loan build() {
            return new LoanImpl(this);
        }

        @Override
        public LoanBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanBuilder prune() {
            super.prune();
            this.borrower = this.borrower.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lien != null && !this.lien.prune().hasData()) {
                this.lien = null;
            }
            if (this.facilityType != null && !this.facilityType.prune().hasData()) {
                this.facilityType = null;
            }
            if (this.tranche != null && !this.tranche.prune().hasData()) {
                this.tranche = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBorrower() != null && this.getBorrower().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLien() != null) {
                return true;
            }
            if (this.getFacilityType() != null) {
                return true;
            }
            if (this.getCreditAgreementDate() != null) {
                return true;
            }
            return this.getTranche() != null;
        }

        @Override
        public LoanBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanBuilder o = (LoanBuilder)other;
            merger.mergeRosetta(this.getBorrower(), o.getBorrower(), this::getOrCreateBorrower);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLien(), (RosettaModelObjectBuilder)o.getLien(), this::setLien);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityType(), (RosettaModelObjectBuilder)o.getFacilityType(), this::setFacilityType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTranche(), (RosettaModelObjectBuilder)o.getTranche(), this::setTranche);
            merger.mergeBasic((Object)this.getCreditAgreementDate(), (Object)o.getCreditAgreementDate(), this::setCreditAgreementDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Loan _that = (Loan)this.getType().cast(o);
            if (!ListEquals.listEquals(this.borrower, _that.getBorrower())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            if (!Objects.equals(this.facilityType, _that.getFacilityType())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.borrower != null ? this.borrower.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanBuilder {borrower=" + this.borrower + ", lien=" + this.lien + ", facilityType=" + this.facilityType + ", creditAgreementDate=" + this.creditAgreementDate + ", tranche=" + this.tranche + '}' + " " + super.toString();
        }
    }

    public static interface LoanBuilder
    extends Loan,
    InstrumentBase.InstrumentBaseBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateBorrower(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getBorrower();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateLien();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getLien();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateFacilityType();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getFacilityType();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateTranche();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getTranche();

        @Override
        public LoanBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public LoanBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public LoanBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public LoanBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public LoanBuilder addTaxonomy(Taxonomy var1);

        @Override
        public LoanBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public LoanBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public LoanBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public LoanBuilder setIsExchangeListed(Boolean var1);

        @Override
        public LoanBuilder setExchange(LegalEntity var1);

        @Override
        public LoanBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public LoanBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public LoanBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public LoanBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public LoanBuilder setInstrumentType(InstrumentTypeEnum var1);

        public LoanBuilder addBorrower(LegalEntity var1);

        public LoanBuilder addBorrower(LegalEntity var1, int var2);

        public LoanBuilder addBorrower(List<? extends LegalEntity> var1);

        public LoanBuilder setBorrower(List<? extends LegalEntity> var1);

        public LoanBuilder setLien(FieldWithMetaString var1);

        public LoanBuilder setLienValue(String var1);

        public LoanBuilder setFacilityType(FieldWithMetaString var1);

        public LoanBuilder setFacilityTypeValue(String var1);

        public LoanBuilder setCreditAgreementDate(Date var1);

        public LoanBuilder setTranche(FieldWithMetaString var1);

        public LoanBuilder setTrancheValue(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("borrower"), processor, LegalEntity.LegalEntityBuilder.class, this.getBorrower(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lien"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getLien(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityType"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getFacilityType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditAgreementDate"), Date.class, (Object)this.getCreditAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tranche"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getTranche(), new AttributeMeta[0]);
        }

        @Override
        public LoanBuilder prune();
    }

    public static class LoanImpl
    extends InstrumentBase.InstrumentBaseImpl
    implements Loan {
        private final List<? extends LegalEntity> borrower;
        private final FieldWithMetaString lien;
        private final FieldWithMetaString facilityType;
        private final Date creditAgreementDate;
        private final FieldWithMetaString tranche;

        protected LoanImpl(LoanBuilder builder) {
            super(builder);
            this.borrower = Optional.ofNullable(builder.getBorrower()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lien = Optional.ofNullable(builder.getLien()).map(f -> f.build()).orElse(null);
            this.facilityType = Optional.ofNullable(builder.getFacilityType()).map(f -> f.build()).orElse(null);
            this.creditAgreementDate = builder.getCreditAgreementDate();
            this.tranche = Optional.ofNullable(builder.getTranche()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="borrower")
        @RuneAttribute(value="borrower")
        public List<? extends LegalEntity> getBorrower() {
            return this.borrower;
        }

        @Override
        @RosettaAttribute(value="lien")
        @RuneAttribute(value="lien")
        public FieldWithMetaString getLien() {
            return this.lien;
        }

        @Override
        @RosettaAttribute(value="facilityType")
        @RuneAttribute(value="facilityType")
        public FieldWithMetaString getFacilityType() {
            return this.facilityType;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate")
        @RuneAttribute(value="creditAgreementDate")
        public Date getCreditAgreementDate() {
            return this.creditAgreementDate;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public FieldWithMetaString getTranche() {
            return this.tranche;
        }

        @Override
        public Loan build() {
            return this;
        }

        @Override
        public LoanBuilder toBuilder() {
            LoanBuilder builder = Loan.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBorrower()).ifPresent(builder::setBorrower);
            Optional.ofNullable(this.getLien()).ifPresent(builder::setLien);
            Optional.ofNullable(this.getFacilityType()).ifPresent(builder::setFacilityType);
            Optional.ofNullable(this.getCreditAgreementDate()).ifPresent(builder::setCreditAgreementDate);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Loan _that = (Loan)this.getType().cast(o);
            if (!ListEquals.listEquals(this.borrower, _that.getBorrower())) {
                return false;
            }
            if (!Objects.equals(this.lien, _that.getLien())) {
                return false;
            }
            if (!Objects.equals(this.facilityType, _that.getFacilityType())) {
                return false;
            }
            if (!Objects.equals(this.creditAgreementDate, _that.getCreditAgreementDate())) {
                return false;
            }
            return Objects.equals(this.tranche, _that.getTranche());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.borrower != null ? this.borrower.hashCode() : 0);
            _result = 31 * _result + (this.lien != null ? this.lien.hashCode() : 0);
            _result = 31 * _result + (this.facilityType != null ? this.facilityType.hashCode() : 0);
            _result = 31 * _result + (this.creditAgreementDate != null ? this.creditAgreementDate.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Loan {borrower=" + this.borrower + ", lien=" + this.lien + ", facilityType=" + this.facilityType + ", creditAgreementDate=" + this.creditAgreementDate + ", tranche=" + this.tranche + '}' + " " + super.toString();
        }
    }
}

