/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetBase;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.meta.InstrumentBaseMeta;
import cdm.base.staticdata.party.LegalEntity;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InstrumentBase", builder=InstrumentBaseBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="InstrumentBase", model="cdm", builder=InstrumentBaseBuilderImpl.class, version="7.0.0-dev.52")
public interface InstrumentBase
extends AssetBase {
    public static final InstrumentBaseMeta metaData = new InstrumentBaseMeta();

    public InstrumentTypeEnum getInstrumentType();

    @Override
    public InstrumentBase build();

    @Override
    public InstrumentBaseBuilder toBuilder();

    public static InstrumentBaseBuilder builder() {
        return new InstrumentBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends InstrumentBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InstrumentBase> getType() {
        return InstrumentBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class InstrumentBaseBuilderImpl
    extends AssetBase.AssetBaseBuilderImpl
    implements InstrumentBaseBuilder {
        protected InstrumentTypeEnum instrumentType;

        @Override
        @RosettaAttribute(value="instrumentType", isRequired=true)
        @RuneAttribute(value="instrumentType", isRequired=true)
        public InstrumentTypeEnum getInstrumentType() {
            return this.instrumentType;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public InstrumentBaseBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public InstrumentBaseBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public InstrumentBaseBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public InstrumentBaseBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public InstrumentBaseBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public InstrumentBaseBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public InstrumentBaseBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public InstrumentBaseBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public InstrumentBaseBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public InstrumentBaseBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public InstrumentBaseBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public InstrumentBaseBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public InstrumentBaseBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public InstrumentBaseBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType", isRequired=true)
        @RuneAttribute(value="instrumentType", isRequired=true)
        public InstrumentBaseBuilder setInstrumentType(InstrumentTypeEnum _instrumentType) {
            this.instrumentType = _instrumentType == null ? null : _instrumentType;
            return this;
        }

        @Override
        public InstrumentBase build() {
            return new InstrumentBaseImpl(this);
        }

        @Override
        public InstrumentBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public InstrumentBaseBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getInstrumentType() != null;
        }

        @Override
        public InstrumentBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InstrumentBaseBuilder o = (InstrumentBaseBuilder)other;
            merger.mergeBasic((Object)this.getInstrumentType(), (Object)o.getInstrumentType(), this::setInstrumentType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InstrumentBase _that = (InstrumentBase)this.getType().cast(o);
            return Objects.equals((Object)this.instrumentType, (Object)_that.getInstrumentType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.instrumentType != null ? ((Object)((Object)this.instrumentType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InstrumentBaseBuilder {instrumentType=" + (Object)((Object)this.instrumentType) + '}' + " " + super.toString();
        }
    }

    public static interface InstrumentBaseBuilder
    extends InstrumentBase,
    AssetBase.AssetBaseBuilder {
        @Override
        public InstrumentBaseBuilder addIdentifier(AssetIdentifier var1);

        @Override
        public InstrumentBaseBuilder addIdentifier(AssetIdentifier var1, int var2);

        @Override
        public InstrumentBaseBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public InstrumentBaseBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        @Override
        public InstrumentBaseBuilder addTaxonomy(Taxonomy var1);

        @Override
        public InstrumentBaseBuilder addTaxonomy(Taxonomy var1, int var2);

        @Override
        public InstrumentBaseBuilder addTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public InstrumentBaseBuilder setTaxonomy(List<? extends Taxonomy> var1);

        @Override
        public InstrumentBaseBuilder setIsExchangeListed(Boolean var1);

        @Override
        public InstrumentBaseBuilder setExchange(LegalEntity var1);

        @Override
        public InstrumentBaseBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public InstrumentBaseBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public InstrumentBaseBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public InstrumentBaseBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        public InstrumentBaseBuilder setInstrumentType(InstrumentTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("instrumentType"), InstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public InstrumentBaseBuilder prune();
    }

    public static class InstrumentBaseImpl
    extends AssetBase.AssetBaseImpl
    implements InstrumentBase {
        private final InstrumentTypeEnum instrumentType;

        protected InstrumentBaseImpl(InstrumentBaseBuilder builder) {
            super(builder);
            this.instrumentType = builder.getInstrumentType();
        }

        @Override
        @RosettaAttribute(value="instrumentType", isRequired=true)
        @RuneAttribute(value="instrumentType", isRequired=true)
        public InstrumentTypeEnum getInstrumentType() {
            return this.instrumentType;
        }

        @Override
        public InstrumentBase build() {
            return this;
        }

        @Override
        public InstrumentBaseBuilder toBuilder() {
            InstrumentBaseBuilder builder = InstrumentBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InstrumentBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInstrumentType()).ifPresent(builder::setInstrumentType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InstrumentBase _that = (InstrumentBase)this.getType().cast(o);
            return Objects.equals((Object)this.instrumentType, (Object)_that.getInstrumentType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.instrumentType != null ? ((Object)((Object)this.instrumentType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InstrumentBase {instrumentType=" + (Object)((Object)this.instrumentType) + '}' + " " + super.toString();
        }
    }
}

