/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.TradePackage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradePackageChoice")
@ImplementedBy(value=Default.class)
public interface TradePackageChoice
extends Validator<TradePackage> {
    public static final String NAME = "TradePackageChoice";
    public static final String DEFINITION = "required choice trade, tradeReferenceInformationModel , tradeIdentifier";

    public static class NoOp
    implements TradePackageChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradePackage tradePackage) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradePackageChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradePackage tradePackage) {
            ComparisonResult result = this.executeDataRule(tradePackage);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradePackageChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradePackage", (RosettaPath)path, (String)TradePackageChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradePackageChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradePackage", (RosettaPath)path, (String)TradePackageChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradePackage tradePackage) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)tradePackage), Arrays.asList("trade", "tradeReferenceInformationModel", "tradeIdentifier"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

