/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Price;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceChoice")
@ImplementedBy(value=Default.class)
public interface PriceChoice
extends Validator<Price> {
    public static final String NAME = "PriceChoice";
    public static final String DEFINITION = "required choice priceSequence, amountRelativeTo , equityPriceModel";

    public static class NoOp
    implements PriceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Price price) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Price price) {
            ComparisonResult result = this.executeDataRule(price);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Price", (RosettaPath)path, (String)PriceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Price price) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)price), Arrays.asList("priceSequence", "amountRelativeTo", "equityPriceModel"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

