/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Portfolio;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PortfolioChoice")
@ImplementedBy(value=Default.class)
public interface PortfolioChoice
extends Validator<Portfolio> {
    public static final String NAME = "PortfolioChoice";
    public static final String DEFINITION = "required choice tradeId, partyTradeIdentifier";

    public static class NoOp
    implements PortfolioChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Portfolio portfolio) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PortfolioChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Portfolio portfolio) {
            ComparisonResult result = this.executeDataRule(portfolio);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PortfolioChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Portfolio", (RosettaPath)path, (String)PortfolioChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PortfolioChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Portfolio", (RosettaPath)path, (String)PortfolioChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Portfolio portfolio) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)portfolio), Arrays.asList("tradeId", "partyTradeIdentifier"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

