/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.OldTradeModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OldTradeModelChoice")
@ImplementedBy(value=Default.class)
public interface OldTradeModelChoice
extends Validator<OldTradeModel> {
    public static final String NAME = "OldTradeModelChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements OldTradeModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OldTradeModel oldTradeModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OldTradeModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OldTradeModel oldTradeModel) {
            ComparisonResult result = this.executeDataRule(oldTradeModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OldTradeModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OldTradeModel", (RosettaPath)path, (String)OldTradeModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OldTradeModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OldTradeModel", (RosettaPath)path, (String)OldTradeModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(OldTradeModel oldTradeModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)oldTradeModel), Arrays.asList("oldTradeIdentifier", "oldTrade"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

