/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.GeneralTerms;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="GeneralTermsChoice")
@ImplementedBy(value=Default.class)
public interface GeneralTermsChoice
extends Validator<GeneralTerms> {
    public static final String NAME = "GeneralTermsChoice";
    public static final String DEFINITION = "required choice referenceInformation, indexReferenceInformation , basketReferenceInformation";

    public static class NoOp
    implements GeneralTermsChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, GeneralTerms generalTerms) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements GeneralTermsChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, GeneralTerms generalTerms) {
            ComparisonResult result = this.executeDataRule(generalTerms);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)GeneralTermsChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"GeneralTerms", (RosettaPath)path, (String)GeneralTermsChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)GeneralTermsChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"GeneralTerms", (RosettaPath)path, (String)GeneralTermsChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(GeneralTerms generalTerms) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)generalTerms), Arrays.asList("referenceInformation", "indexReferenceInformation", "basketReferenceInformation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

