/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.FloatingLegCalculation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FloatingLegCalculationChoice")
@ImplementedBy(value=Default.class)
public interface FloatingLegCalculationChoice
extends Validator<FloatingLegCalculation> {
    public static final String NAME = "FloatingLegCalculationChoice";
    public static final String DEFINITION = "optional choice spread, spreadSchedule , spreadPercentage";

    public static class NoOp
    implements FloatingLegCalculationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingLegCalculation floatingLegCalculation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FloatingLegCalculationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingLegCalculation floatingLegCalculation) {
            ComparisonResult result = this.executeDataRule(floatingLegCalculation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FloatingLegCalculationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FloatingLegCalculation", (RosettaPath)path, (String)FloatingLegCalculationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FloatingLegCalculationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FloatingLegCalculation", (RosettaPath)path, (String)FloatingLegCalculationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FloatingLegCalculation floatingLegCalculation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)floatingLegCalculation), Arrays.asList("spread", "spreadSchedule", "spreadPercentage"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

