/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.FixedRecoveryModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FixedRecoveryModelChoice")
@ImplementedBy(value=Default.class)
public interface FixedRecoveryModelChoice
extends Validator<FixedRecoveryModel> {
    public static final String NAME = "FixedRecoveryModelChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements FixedRecoveryModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FixedRecoveryModel fixedRecoveryModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FixedRecoveryModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FixedRecoveryModel fixedRecoveryModel) {
            ComparisonResult result = this.executeDataRule(fixedRecoveryModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FixedRecoveryModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedRecoveryModel", (RosettaPath)path, (String)FixedRecoveryModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FixedRecoveryModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedRecoveryModel", (RosettaPath)path, (String)FixedRecoveryModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FixedRecoveryModel fixedRecoveryModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)fixedRecoveryModel), Arrays.asList("cashSettlementAmount", "recoveryFactor"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

