/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ExtraordinaryEvents;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExtraordinaryEventsChoice")
@ImplementedBy(value=Default.class)
public interface ExtraordinaryEventsChoice
extends Validator<ExtraordinaryEvents> {
    public static final String NAME = "ExtraordinaryEventsChoice";
    public static final String DEFINITION = "required choice additionalDisruptionEvents, failureToDeliver";

    public static class NoOp
    implements ExtraordinaryEventsChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExtraordinaryEvents extraordinaryEvents) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExtraordinaryEventsChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExtraordinaryEvents extraordinaryEvents) {
            ComparisonResult result = this.executeDataRule(extraordinaryEvents);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExtraordinaryEventsChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExtraordinaryEvents", (RosettaPath)path, (String)ExtraordinaryEventsChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExtraordinaryEventsChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExtraordinaryEvents", (RosettaPath)path, (String)ExtraordinaryEventsChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExtraordinaryEvents extraordinaryEvents) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)extraordinaryEvents), Arrays.asList("additionalDisruptionEvents", "failureToDeliver"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

