/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ExecutionNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExecutionNotificationChoice")
@ImplementedBy(value=Default.class)
public interface ExecutionNotificationChoice
extends Validator<ExecutionNotification> {
    public static final String NAME = "ExecutionNotificationChoice";
    public static final String DEFINITION = "required choice tradingEventsBaseModel, amendment , optionsEventsBaseModel , additionalEvent";

    public static class NoOp
    implements ExecutionNotificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionNotification executionNotification) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExecutionNotificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionNotification executionNotification) {
            ComparisonResult result = this.executeDataRule(executionNotification);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExecutionNotificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionNotification", (RosettaPath)path, (String)ExecutionNotificationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExecutionNotificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionNotification", (RosettaPath)path, (String)ExecutionNotificationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExecutionNotification executionNotification) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)executionNotification), Arrays.asList("tradingEventsBaseModel", "amendment", "optionsEventsBaseModel", "additionalEvent"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

