/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ExecutionAdvice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExecutionAdviceChoice")
@ImplementedBy(value=Default.class)
public interface ExecutionAdviceChoice
extends Validator<ExecutionAdvice> {
    public static final String NAME = "ExecutionAdviceChoice";
    public static final String DEFINITION = "required choice tradingEventsBaseModel, postTradeEventsBaseModel , changeEventsBaseModel , optionsEventsBaseModel , additionalEvent";

    public static class NoOp
    implements ExecutionAdviceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionAdvice executionAdvice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExecutionAdviceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionAdvice executionAdvice) {
            ComparisonResult result = this.executeDataRule(executionAdvice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExecutionAdviceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionAdvice", (RosettaPath)path, (String)ExecutionAdviceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExecutionAdviceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionAdvice", (RosettaPath)path, (String)ExecutionAdviceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExecutionAdvice executionAdvice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)executionAdvice), Arrays.asList("tradingEventsBaseModel", "postTradeEventsBaseModel", "changeEventsBaseModel", "optionsEventsBaseModel", "additionalEvent"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

