/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CovenantObligationIdentifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CovenantObligationIdentifierChoice")
@ImplementedBy(value=Default.class)
public interface CovenantObligationIdentifierChoice
extends Validator<CovenantObligationIdentifier> {
    public static final String NAME = "CovenantObligationIdentifierChoice";
    public static final String DEFINITION = "required choice covenantObligationId, versionedCovenantObligationId";

    public static class NoOp
    implements CovenantObligationIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CovenantObligationIdentifier covenantObligationIdentifier) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CovenantObligationIdentifierChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CovenantObligationIdentifier covenantObligationIdentifier) {
            ComparisonResult result = this.executeDataRule(covenantObligationIdentifier);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CovenantObligationIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CovenantObligationIdentifier", (RosettaPath)path, (String)CovenantObligationIdentifierChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CovenantObligationIdentifierChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CovenantObligationIdentifier", (RosettaPath)path, (String)CovenantObligationIdentifierChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CovenantObligationIdentifier covenantObligationIdentifier) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)covenantObligationIdentifier), Arrays.asList("covenantObligationId", "versionedCovenantObligationId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

