/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CommodityExercise;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CommodityExerciseChoice")
@ImplementedBy(value=Default.class)
public interface CommodityExerciseChoice
extends Validator<CommodityExercise> {
    public static final String NAME = "CommodityExerciseChoice";
    public static final String DEFINITION = "required choice americanExercise, europeanExercise";

    public static class NoOp
    implements CommodityExerciseChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityExercise commodityExercise) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CommodityExerciseChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityExercise commodityExercise) {
            ComparisonResult result = this.executeDataRule(commodityExercise);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CommodityExerciseChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityExercise", (RosettaPath)path, (String)CommodityExerciseChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CommodityExerciseChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityExercise", (RosettaPath)path, (String)CommodityExerciseChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CommodityExercise commodityExercise) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)commodityExercise), Arrays.asList("americanExercise", "europeanExercise"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

