/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.BondCollateralModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BondCollateralModelChoice")
@ImplementedBy(value=Default.class)
public interface BondCollateralModelChoice
extends Validator<BondCollateralModel> {
    public static final String NAME = "BondCollateralModelChoice";
    public static final String DEFINITION = "required choice bondCollateralModelSequence, quantity";

    public static class NoOp
    implements BondCollateralModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondCollateralModel bondCollateralModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BondCollateralModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BondCollateralModel bondCollateralModel) {
            ComparisonResult result = this.executeDataRule(bondCollateralModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BondCollateralModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BondCollateralModel", (RosettaPath)path, (String)BondCollateralModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BondCollateralModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BondCollateralModel", (RosettaPath)path, (String)BondCollateralModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BondCollateralModel bondCollateralModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)bondCollateralModel), Arrays.asList("bondCollateralModelSequence", "quantity"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

