/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.custom.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.confirmation.Document;
import fpml.confirmation.custom.DocumentChoice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToDocumentChoiceDefault.class)
public abstract class ToDocumentChoice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public DocumentChoice evaluate(Document document) {
        DocumentChoice documentChoice;
        DocumentChoice.DocumentChoiceBuilder documentChoiceBuilder = this.doEvaluate(document);
        if (documentChoiceBuilder == null) {
            documentChoice = null;
        } else {
            documentChoice = documentChoiceBuilder.build();
            this.objectValidator.validate(DocumentChoice.class, (RosettaModelObject)documentChoice);
        }
        return documentChoice;
    }

    protected abstract DocumentChoice.DocumentChoiceBuilder doEvaluate(Document var1);

    public static class ToDocumentChoiceDefault
    extends ToDocumentChoice {
        @Override
        protected DocumentChoice.DocumentChoiceBuilder doEvaluate(Document document) {
            DocumentChoice.DocumentChoiceBuilder documentChoice = DocumentChoice.builder();
            return this.assignOutput(documentChoice, document);
        }

        protected DocumentChoice.DocumentChoiceBuilder assignOutput(DocumentChoice.DocumentChoiceBuilder documentChoice, Document document) {
            return Optional.ofNullable(documentChoice).map(o -> o.prune()).orElse(null);
        }
    }
}

