/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.CalculationFromObservation;
import fpml.confirmation.CalculationFromObservationChoice;
import fpml.confirmation.VolatilityCap;
import fpml.confirmation.meta.VolatilityMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Volatility", builder=VolatilityBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Volatility", model="fpml", builder=VolatilityBuilderImpl.class, version="0.17.2")
public interface Volatility
extends CalculationFromObservation {
    public static final VolatilityMeta metaData = new VolatilityMeta();

    public VolatilityCap getVolatilityCap();

    public BigDecimal getVolatilityStrikePrice();

    public BigDecimal getVegaNotionalAmount();

    @Override
    public Volatility build();

    @Override
    public VolatilityBuilder toBuilder();

    public static VolatilityBuilder builder() {
        return new VolatilityBuilderImpl();
    }

    default public RosettaMetaData<? extends Volatility> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Volatility> getType() {
        return Volatility.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationFromObservationChoice"), processor, CalculationFromObservationChoice.class, this.getCalculationFromObservationChoice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("closingLevel"), Boolean.class, (Object)this.getClosingLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expiringLevel"), Boolean.class, (Object)this.getExpiringLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityCap"), processor, VolatilityCap.class, this.getVolatilityCap(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("volatilityStrikePrice"), BigDecimal.class, (Object)this.getVolatilityStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("vegaNotionalAmount"), BigDecimal.class, (Object)this.getVegaNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class VolatilityBuilderImpl
    extends CalculationFromObservation.CalculationFromObservationBuilderImpl
    implements VolatilityBuilder {
        protected VolatilityCap.VolatilityCapBuilder volatilityCap;
        protected BigDecimal volatilityStrikePrice;
        protected BigDecimal vegaNotionalAmount;

        @Override
        @RosettaAttribute(value="volatilityCap", isRequired=true)
        @RuneAttribute(value="volatilityCap", isRequired=true)
        public VolatilityCap.VolatilityCapBuilder getVolatilityCap() {
            return this.volatilityCap;
        }

        @Override
        public VolatilityCap.VolatilityCapBuilder getOrCreateVolatilityCap() {
            VolatilityCap.VolatilityCapBuilder result = this.volatilityCap != null ? this.volatilityCap : (this.volatilityCap = VolatilityCap.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="volatilityStrikePrice", isRequired=true)
        public BigDecimal getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="vegaNotionalAmount", isRequired=true)
        @RuneAttribute(value="vegaNotionalAmount", isRequired=true)
        public BigDecimal getVegaNotionalAmount() {
            return this.vegaNotionalAmount;
        }

        @Override
        @RosettaAttribute(value="calculationFromObservationChoice")
        @RuneAttribute(value="calculationFromObservationChoice")
        public VolatilityBuilder setCalculationFromObservationChoice(CalculationFromObservationChoice _calculationFromObservationChoice) {
            this.calculationFromObservationChoice = _calculationFromObservationChoice == null ? null : _calculationFromObservationChoice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="closingLevel")
        @RuneAttribute(value="closingLevel")
        public VolatilityBuilder setClosingLevel(Boolean _closingLevel) {
            this.closingLevel = _closingLevel == null ? null : _closingLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="expiringLevel")
        @RuneAttribute(value="expiringLevel")
        public VolatilityBuilder setExpiringLevel(Boolean _expiringLevel) {
            this.expiringLevel = _expiringLevel == null ? null : _expiringLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedN")
        @RuneAttribute(value="expectedN")
        public VolatilityBuilder setExpectedN(Integer _expectedN) {
            this.expectedN = _expectedN == null ? null : _expectedN;
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityCap", isRequired=true)
        @RuneAttribute(value="volatilityCap", isRequired=true)
        public VolatilityBuilder setVolatilityCap(VolatilityCap _volatilityCap) {
            this.volatilityCap = _volatilityCap == null ? null : _volatilityCap.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="volatilityStrikePrice", isRequired=true)
        public VolatilityBuilder setVolatilityStrikePrice(BigDecimal _volatilityStrikePrice) {
            this.volatilityStrikePrice = _volatilityStrikePrice == null ? null : _volatilityStrikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="vegaNotionalAmount", isRequired=true)
        @RuneAttribute(value="vegaNotionalAmount", isRequired=true)
        public VolatilityBuilder setVegaNotionalAmount(BigDecimal _vegaNotionalAmount) {
            this.vegaNotionalAmount = _vegaNotionalAmount == null ? null : _vegaNotionalAmount;
            return this;
        }

        @Override
        public Volatility build() {
            return new VolatilityImpl(this);
        }

        @Override
        public VolatilityBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityBuilder prune() {
            super.prune();
            if (this.volatilityCap != null && !this.volatilityCap.prune().hasData()) {
                this.volatilityCap = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getVolatilityCap() != null && this.getVolatilityCap().hasData()) {
                return true;
            }
            if (this.getVolatilityStrikePrice() != null) {
                return true;
            }
            return this.getVegaNotionalAmount() != null;
        }

        @Override
        public VolatilityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityBuilder o = (VolatilityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityCap(), (RosettaModelObjectBuilder)o.getVolatilityCap(), this::setVolatilityCap);
            merger.mergeBasic((Object)this.getVolatilityStrikePrice(), (Object)o.getVolatilityStrikePrice(), this::setVolatilityStrikePrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVegaNotionalAmount(), (Object)o.getVegaNotionalAmount(), this::setVegaNotionalAmount, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Volatility _that = (Volatility)this.getType().cast(o);
            if (!Objects.equals(this.volatilityCap, _that.getVolatilityCap())) {
                return false;
            }
            if (!Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice())) {
                return false;
            }
            return Objects.equals(this.vegaNotionalAmount, _that.getVegaNotionalAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityCap != null ? this.volatilityCap.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotionalAmount != null ? this.vegaNotionalAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityBuilder {volatilityCap=" + this.volatilityCap + ", volatilityStrikePrice=" + this.volatilityStrikePrice + ", vegaNotionalAmount=" + this.vegaNotionalAmount + '}' + " " + super.toString();
        }
    }

    public static interface VolatilityBuilder
    extends Volatility,
    CalculationFromObservation.CalculationFromObservationBuilder {
        public VolatilityCap.VolatilityCapBuilder getOrCreateVolatilityCap();

        @Override
        public VolatilityCap.VolatilityCapBuilder getVolatilityCap();

        @Override
        public VolatilityBuilder setCalculationFromObservationChoice(CalculationFromObservationChoice var1);

        @Override
        public VolatilityBuilder setClosingLevel(Boolean var1);

        @Override
        public VolatilityBuilder setExpiringLevel(Boolean var1);

        @Override
        public VolatilityBuilder setExpectedN(Integer var1);

        public VolatilityBuilder setVolatilityCap(VolatilityCap var1);

        public VolatilityBuilder setVolatilityStrikePrice(BigDecimal var1);

        public VolatilityBuilder setVegaNotionalAmount(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationFromObservationChoice"), processor, CalculationFromObservationChoice.CalculationFromObservationChoiceBuilder.class, (RosettaModelObjectBuilder)this.getCalculationFromObservationChoice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("closingLevel"), Boolean.class, (Object)this.getClosingLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expiringLevel"), Boolean.class, (Object)this.getExpiringLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityCap"), processor, VolatilityCap.VolatilityCapBuilder.class, this.getVolatilityCap(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("volatilityStrikePrice"), BigDecimal.class, (Object)this.getVolatilityStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("vegaNotionalAmount"), BigDecimal.class, (Object)this.getVegaNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public VolatilityBuilder prune();
    }

    public static class VolatilityImpl
    extends CalculationFromObservation.CalculationFromObservationImpl
    implements Volatility {
        private final VolatilityCap volatilityCap;
        private final BigDecimal volatilityStrikePrice;
        private final BigDecimal vegaNotionalAmount;

        protected VolatilityImpl(VolatilityBuilder builder) {
            super(builder);
            this.volatilityCap = Optional.ofNullable(builder.getVolatilityCap()).map(f -> f.build()).orElse(null);
            this.volatilityStrikePrice = builder.getVolatilityStrikePrice();
            this.vegaNotionalAmount = builder.getVegaNotionalAmount();
        }

        @Override
        @RosettaAttribute(value="volatilityCap", isRequired=true)
        @RuneAttribute(value="volatilityCap", isRequired=true)
        public VolatilityCap getVolatilityCap() {
            return this.volatilityCap;
        }

        @Override
        @RosettaAttribute(value="volatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="volatilityStrikePrice", isRequired=true)
        public BigDecimal getVolatilityStrikePrice() {
            return this.volatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="vegaNotionalAmount", isRequired=true)
        @RuneAttribute(value="vegaNotionalAmount", isRequired=true)
        public BigDecimal getVegaNotionalAmount() {
            return this.vegaNotionalAmount;
        }

        @Override
        public Volatility build() {
            return this;
        }

        @Override
        public VolatilityBuilder toBuilder() {
            VolatilityBuilder builder = Volatility.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVolatilityCap()).ifPresent(builder::setVolatilityCap);
            Optional.ofNullable(this.getVolatilityStrikePrice()).ifPresent(builder::setVolatilityStrikePrice);
            Optional.ofNullable(this.getVegaNotionalAmount()).ifPresent(builder::setVegaNotionalAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Volatility _that = (Volatility)this.getType().cast(o);
            if (!Objects.equals(this.volatilityCap, _that.getVolatilityCap())) {
                return false;
            }
            if (!Objects.equals(this.volatilityStrikePrice, _that.getVolatilityStrikePrice())) {
                return false;
            }
            return Objects.equals(this.vegaNotionalAmount, _that.getVegaNotionalAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityCap != null ? this.volatilityCap.hashCode() : 0);
            _result = 31 * _result + (this.volatilityStrikePrice != null ? this.volatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotionalAmount != null ? this.vegaNotionalAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Volatility {volatilityCap=" + this.volatilityCap + ", volatilityStrikePrice=" + this.volatilityStrikePrice + ", vegaNotionalAmount=" + this.vegaNotionalAmount + '}' + " " + super.toString();
        }
    }
}

