/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AgreementAndEffectiveDatesModel;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.PartyTradeIdentifier;
import fpml.confirmation.Trade;
import fpml.confirmation.TradeAlterationPaymentModel;
import fpml.confirmation.TradeChangeBase;
import fpml.confirmation.TradeLegPriceChange;
import fpml.confirmation.TradeLegSizeChange;
import fpml.confirmation.TradeNotionalChangeModel;
import fpml.confirmation.meta.TradeNotionalChangeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeNotionalChange", builder=TradeNotionalChangeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TradeNotionalChange", model="fpml", builder=TradeNotionalChangeBuilderImpl.class, version="0.17.2")
public interface TradeNotionalChange
extends TradeChangeBase {
    public static final TradeNotionalChangeMeta metaData = new TradeNotionalChangeMeta();

    public TradeNotionalChangeModel getTradeNotionalChangeModel();

    public List<? extends TradeLegSizeChange> getSizeChange();

    public List<? extends TradeLegPriceChange> getPriceChange();

    @Override
    public TradeNotionalChange build();

    @Override
    public TradeNotionalChangeBuilder toBuilder();

    public static TradeNotionalChangeBuilder builder() {
        return new TradeNotionalChangeBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeNotionalChange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeNotionalChange> getType() {
        return TradeNotionalChange.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.class, this.getOriginalTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resultingTrade"), processor, Trade.class, this.getResultingTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementAndEffectiveDatesModel"), processor, AgreementAndEffectiveDatesModel.class, this.getAgreementAndEffectiveDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeAlterationPaymentModel"), processor, TradeAlterationPaymentModel.class, this.getTradeAlterationPaymentModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeNotionalChangeModel"), processor, TradeNotionalChangeModel.class, this.getTradeNotionalChangeModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sizeChange"), processor, TradeLegSizeChange.class, this.getSizeChange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceChange"), processor, TradeLegPriceChange.class, this.getPriceChange(), new AttributeMeta[0]);
    }

    public static class TradeNotionalChangeBuilderImpl
    extends TradeChangeBase.TradeChangeBaseBuilderImpl
    implements TradeNotionalChangeBuilder {
        protected TradeNotionalChangeModel.TradeNotionalChangeModelBuilder tradeNotionalChangeModel;
        protected List<TradeLegSizeChange.TradeLegSizeChangeBuilder> sizeChange = new ArrayList<TradeLegSizeChange.TradeLegSizeChangeBuilder>();
        protected List<TradeLegPriceChange.TradeLegPriceChangeBuilder> priceChange = new ArrayList<TradeLegPriceChange.TradeLegPriceChangeBuilder>();

        @Override
        @RosettaAttribute(value="tradeNotionalChangeModel")
        @RuneAttribute(value="tradeNotionalChangeModel")
        public TradeNotionalChangeModel.TradeNotionalChangeModelBuilder getTradeNotionalChangeModel() {
            return this.tradeNotionalChangeModel;
        }

        @Override
        public TradeNotionalChangeModel.TradeNotionalChangeModelBuilder getOrCreateTradeNotionalChangeModel() {
            TradeNotionalChangeModel.TradeNotionalChangeModelBuilder result = this.tradeNotionalChangeModel != null ? this.tradeNotionalChangeModel : (this.tradeNotionalChangeModel = TradeNotionalChangeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sizeChange")
        @RuneAttribute(value="sizeChange")
        public List<? extends TradeLegSizeChange.TradeLegSizeChangeBuilder> getSizeChange() {
            return this.sizeChange;
        }

        @Override
        public TradeLegSizeChange.TradeLegSizeChangeBuilder getOrCreateSizeChange(int index) {
            if (this.sizeChange == null) {
                this.sizeChange = new ArrayList<TradeLegSizeChange.TradeLegSizeChangeBuilder>();
            }
            return (TradeLegSizeChange.TradeLegSizeChangeBuilder)this.getIndex(this.sizeChange, index, () -> {
                TradeLegSizeChange.TradeLegSizeChangeBuilder newSizeChange = TradeLegSizeChange.builder();
                return newSizeChange;
            });
        }

        @Override
        @RosettaAttribute(value="priceChange")
        @RuneAttribute(value="priceChange")
        public List<? extends TradeLegPriceChange.TradeLegPriceChangeBuilder> getPriceChange() {
            return this.priceChange;
        }

        @Override
        public TradeLegPriceChange.TradeLegPriceChangeBuilder getOrCreatePriceChange(int index) {
            if (this.priceChange == null) {
                this.priceChange = new ArrayList<TradeLegPriceChange.TradeLegPriceChangeBuilder>();
            }
            return (TradeLegPriceChange.TradeLegPriceChangeBuilder)this.getIndex(this.priceChange, index, () -> {
                TradeLegPriceChange.TradeLegPriceChangeBuilder newPriceChange = TradeLegPriceChange.builder();
                return newPriceChange;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public TradeNotionalChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public TradeNotionalChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradeNotionalChangeBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public TradeNotionalChangeBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public TradeNotionalChangeBuilder setOriginalTrade(Trade _originalTrade) {
            this.originalTrade = _originalTrade == null ? null : _originalTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="resultingTrade")
        @RuneAttribute(value="resultingTrade")
        public TradeNotionalChangeBuilder setResultingTrade(Trade _resultingTrade) {
            this.resultingTrade = _resultingTrade == null ? null : _resultingTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public TradeNotionalChangeBuilder setAgreementAndEffectiveDatesModel(AgreementAndEffectiveDatesModel _agreementAndEffectiveDatesModel) {
            this.agreementAndEffectiveDatesModel = _agreementAndEffectiveDatesModel == null ? null : _agreementAndEffectiveDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        @RuneAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        public TradeNotionalChangeBuilder setTradeAlterationPaymentModel(TradeAlterationPaymentModel _tradeAlterationPaymentModel) {
            this.tradeAlterationPaymentModel = _tradeAlterationPaymentModel == null ? null : _tradeAlterationPaymentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeNotionalChangeModel")
        @RuneAttribute(value="tradeNotionalChangeModel")
        public TradeNotionalChangeBuilder setTradeNotionalChangeModel(TradeNotionalChangeModel _tradeNotionalChangeModel) {
            this.tradeNotionalChangeModel = _tradeNotionalChangeModel == null ? null : _tradeNotionalChangeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sizeChange")
        @RuneAttribute(value="sizeChange")
        public TradeNotionalChangeBuilder addSizeChange(TradeLegSizeChange _sizeChange) {
            if (_sizeChange != null) {
                this.sizeChange.add(_sizeChange.toBuilder());
            }
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addSizeChange(TradeLegSizeChange _sizeChange, int idx) {
            this.getIndex(this.sizeChange, idx, () -> _sizeChange.toBuilder());
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addSizeChange(List<? extends TradeLegSizeChange> sizeChanges) {
            if (sizeChanges != null) {
                for (TradeLegSizeChange tradeLegSizeChange : sizeChanges) {
                    this.sizeChange.add(tradeLegSizeChange.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sizeChange")
        public TradeNotionalChangeBuilder setSizeChange(List<? extends TradeLegSizeChange> sizeChanges) {
            this.sizeChange = sizeChanges == null ? new ArrayList<TradeLegSizeChange.TradeLegSizeChangeBuilder>() : (List)sizeChanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="priceChange")
        @RuneAttribute(value="priceChange")
        public TradeNotionalChangeBuilder addPriceChange(TradeLegPriceChange _priceChange) {
            if (_priceChange != null) {
                this.priceChange.add(_priceChange.toBuilder());
            }
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addPriceChange(TradeLegPriceChange _priceChange, int idx) {
            this.getIndex(this.priceChange, idx, () -> _priceChange.toBuilder());
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder addPriceChange(List<? extends TradeLegPriceChange> priceChanges) {
            if (priceChanges != null) {
                for (TradeLegPriceChange tradeLegPriceChange : priceChanges) {
                    this.priceChange.add(tradeLegPriceChange.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceChange")
        public TradeNotionalChangeBuilder setPriceChange(List<? extends TradeLegPriceChange> priceChanges) {
            this.priceChange = priceChanges == null ? new ArrayList<TradeLegPriceChange.TradeLegPriceChangeBuilder>() : (List)priceChanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeNotionalChange build() {
            return new TradeNotionalChangeImpl(this);
        }

        @Override
        public TradeNotionalChangeBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder prune() {
            super.prune();
            if (this.tradeNotionalChangeModel != null && !this.tradeNotionalChangeModel.prune().hasData()) {
                this.tradeNotionalChangeModel = null;
            }
            this.sizeChange = this.sizeChange.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.priceChange = this.priceChange.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeNotionalChangeModel() != null && this.getTradeNotionalChangeModel().hasData()) {
                return true;
            }
            if (this.getSizeChange() != null && this.getSizeChange().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPriceChange() != null && this.getPriceChange().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public TradeNotionalChangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TradeNotionalChangeBuilder o = (TradeNotionalChangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeNotionalChangeModel(), (RosettaModelObjectBuilder)o.getTradeNotionalChangeModel(), this::setTradeNotionalChangeModel);
            merger.mergeRosetta(this.getSizeChange(), o.getSizeChange(), this::getOrCreateSizeChange);
            merger.mergeRosetta(this.getPriceChange(), o.getPriceChange(), this::getOrCreatePriceChange);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeNotionalChange _that = (TradeNotionalChange)this.getType().cast(o);
            if (!Objects.equals(this.tradeNotionalChangeModel, _that.getTradeNotionalChangeModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sizeChange, _that.getSizeChange())) {
                return false;
            }
            return ListEquals.listEquals(this.priceChange, _that.getPriceChange());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeNotionalChangeModel != null ? this.tradeNotionalChangeModel.hashCode() : 0);
            _result = 31 * _result + (this.sizeChange != null ? this.sizeChange.hashCode() : 0);
            _result = 31 * _result + (this.priceChange != null ? this.priceChange.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeNotionalChangeBuilder {tradeNotionalChangeModel=" + this.tradeNotionalChangeModel + ", sizeChange=" + this.sizeChange + ", priceChange=" + this.priceChange + '}' + " " + super.toString();
        }
    }

    public static interface TradeNotionalChangeBuilder
    extends TradeNotionalChange,
    TradeChangeBase.TradeChangeBaseBuilder {
        public TradeNotionalChangeModel.TradeNotionalChangeModelBuilder getOrCreateTradeNotionalChangeModel();

        @Override
        public TradeNotionalChangeModel.TradeNotionalChangeModelBuilder getTradeNotionalChangeModel();

        public TradeLegSizeChange.TradeLegSizeChangeBuilder getOrCreateSizeChange(int var1);

        public List<? extends TradeLegSizeChange.TradeLegSizeChangeBuilder> getSizeChange();

        public TradeLegPriceChange.TradeLegPriceChangeBuilder getOrCreatePriceChange(int var1);

        public List<? extends TradeLegPriceChange.TradeLegPriceChangeBuilder> getPriceChange();

        @Override
        public TradeNotionalChangeBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public TradeNotionalChangeBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public TradeNotionalChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public TradeNotionalChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public TradeNotionalChangeBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        @Override
        public TradeNotionalChangeBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        @Override
        public TradeNotionalChangeBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        @Override
        public TradeNotionalChangeBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        @Override
        public TradeNotionalChangeBuilder setOriginalTrade(Trade var1);

        @Override
        public TradeNotionalChangeBuilder setResultingTrade(Trade var1);

        @Override
        public TradeNotionalChangeBuilder setAgreementAndEffectiveDatesModel(AgreementAndEffectiveDatesModel var1);

        @Override
        public TradeNotionalChangeBuilder setTradeAlterationPaymentModel(TradeAlterationPaymentModel var1);

        public TradeNotionalChangeBuilder setTradeNotionalChangeModel(TradeNotionalChangeModel var1);

        public TradeNotionalChangeBuilder addSizeChange(TradeLegSizeChange var1);

        public TradeNotionalChangeBuilder addSizeChange(TradeLegSizeChange var1, int var2);

        public TradeNotionalChangeBuilder addSizeChange(List<? extends TradeLegSizeChange> var1);

        public TradeNotionalChangeBuilder setSizeChange(List<? extends TradeLegSizeChange> var1);

        public TradeNotionalChangeBuilder addPriceChange(TradeLegPriceChange var1);

        public TradeNotionalChangeBuilder addPriceChange(TradeLegPriceChange var1, int var2);

        public TradeNotionalChangeBuilder addPriceChange(List<? extends TradeLegPriceChange> var1);

        public TradeNotionalChangeBuilder setPriceChange(List<? extends TradeLegPriceChange> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.TradeBuilder.class, (RosettaModelObjectBuilder)this.getOriginalTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resultingTrade"), processor, Trade.TradeBuilder.class, (RosettaModelObjectBuilder)this.getResultingTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementAndEffectiveDatesModel"), processor, AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder.class, (RosettaModelObjectBuilder)this.getAgreementAndEffectiveDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeAlterationPaymentModel"), processor, TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder.class, (RosettaModelObjectBuilder)this.getTradeAlterationPaymentModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeNotionalChangeModel"), processor, TradeNotionalChangeModel.TradeNotionalChangeModelBuilder.class, this.getTradeNotionalChangeModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sizeChange"), processor, TradeLegSizeChange.TradeLegSizeChangeBuilder.class, this.getSizeChange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceChange"), processor, TradeLegPriceChange.TradeLegPriceChangeBuilder.class, this.getPriceChange(), new AttributeMeta[0]);
        }

        @Override
        public TradeNotionalChangeBuilder prune();
    }

    public static class TradeNotionalChangeImpl
    extends TradeChangeBase.TradeChangeBaseImpl
    implements TradeNotionalChange {
        private final TradeNotionalChangeModel tradeNotionalChangeModel;
        private final List<? extends TradeLegSizeChange> sizeChange;
        private final List<? extends TradeLegPriceChange> priceChange;

        protected TradeNotionalChangeImpl(TradeNotionalChangeBuilder builder) {
            super(builder);
            this.tradeNotionalChangeModel = Optional.ofNullable(builder.getTradeNotionalChangeModel()).map(f -> f.build()).orElse(null);
            this.sizeChange = Optional.ofNullable(builder.getSizeChange()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.priceChange = Optional.ofNullable(builder.getPriceChange()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeNotionalChangeModel")
        @RuneAttribute(value="tradeNotionalChangeModel")
        public TradeNotionalChangeModel getTradeNotionalChangeModel() {
            return this.tradeNotionalChangeModel;
        }

        @Override
        @RosettaAttribute(value="sizeChange")
        @RuneAttribute(value="sizeChange")
        public List<? extends TradeLegSizeChange> getSizeChange() {
            return this.sizeChange;
        }

        @Override
        @RosettaAttribute(value="priceChange")
        @RuneAttribute(value="priceChange")
        public List<? extends TradeLegPriceChange> getPriceChange() {
            return this.priceChange;
        }

        @Override
        public TradeNotionalChange build() {
            return this;
        }

        @Override
        public TradeNotionalChangeBuilder toBuilder() {
            TradeNotionalChangeBuilder builder = TradeNotionalChange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeNotionalChangeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeNotionalChangeModel()).ifPresent(builder::setTradeNotionalChangeModel);
            Optional.ofNullable(this.getSizeChange()).ifPresent(builder::setSizeChange);
            Optional.ofNullable(this.getPriceChange()).ifPresent(builder::setPriceChange);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeNotionalChange _that = (TradeNotionalChange)this.getType().cast(o);
            if (!Objects.equals(this.tradeNotionalChangeModel, _that.getTradeNotionalChangeModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sizeChange, _that.getSizeChange())) {
                return false;
            }
            return ListEquals.listEquals(this.priceChange, _that.getPriceChange());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeNotionalChangeModel != null ? this.tradeNotionalChangeModel.hashCode() : 0);
            _result = 31 * _result + (this.sizeChange != null ? this.sizeChange.hashCode() : 0);
            _result = 31 * _result + (this.priceChange != null ? this.priceChange.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeNotionalChange {tradeNotionalChangeModel=" + this.tradeNotionalChangeModel + ", sizeChange=" + this.sizeChange + ", priceChange=" + this.priceChange + '}' + " " + super.toString();
        }
    }
}

