/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.PartyTradeIdentifier;
import fpml.confirmation.meta.TradeMaturityMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeMaturity", builder=TradeMaturityBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TradeMaturity", model="fpml", builder=TradeMaturityBuilderImpl.class, version="0.17.2")
public interface TradeMaturity
extends RosettaModelObject {
    public static final TradeMaturityMeta metaData = new TradeMaturityMeta();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public ZonedDateTime getDate();

    public TradeMaturity build();

    public TradeMaturityBuilder toBuilder();

    public static TradeMaturityBuilder builder() {
        return new TradeMaturityBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeMaturity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeMaturity> getType() {
        return TradeMaturity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TradeMaturityBuilderImpl
    implements TradeMaturityBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected ZonedDateTime date;

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public TradeMaturityBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeMaturityBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeMaturityBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public TradeMaturityBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public TradeMaturityBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        public TradeMaturity build() {
            return new TradeMaturityImpl(this);
        }

        @Override
        public TradeMaturityBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeMaturityBuilder prune() {
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDate() != null;
        }

        public TradeMaturityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeMaturityBuilder o = (TradeMaturityBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeMaturity _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeMaturityBuilder {tradeIdentifier=" + this.tradeIdentifier + ", date=" + this.date + '}';
        }
    }

    public static interface TradeMaturityBuilder
    extends TradeMaturity,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public TradeMaturityBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public TradeMaturityBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public TradeMaturityBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeMaturityBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeMaturityBuilder setDate(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TradeMaturityBuilder prune();
    }

    public static class TradeMaturityImpl
    implements TradeMaturity {
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final ZonedDateTime date;

        protected TradeMaturityImpl(TradeMaturityBuilder builder) {
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.date = builder.getDate();
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        public TradeMaturity build() {
            return this;
        }

        @Override
        public TradeMaturityBuilder toBuilder() {
            TradeMaturityBuilder builder = TradeMaturity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeMaturityBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeMaturity _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            return Objects.equals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeMaturity {tradeIdentifier=" + this.tradeIdentifier + ", date=" + this.date + '}';
        }
    }
}

