/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.IdentifiedPayerReceiver;
import fpml.confirmation.meta.StrikeMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Strike", builder=StrikeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Strike", model="fpml", builder=StrikeBuilderImpl.class, version="0.17.2")
public interface Strike
extends RosettaModelObject {
    public static final StrikeMeta metaData = new StrikeMeta();

    public BigDecimal getStrikeRate();

    public IdentifiedPayerReceiver getBuyer();

    public IdentifiedPayerReceiver getSeller();

    public String getId();

    public Strike build();

    public StrikeBuilder toBuilder();

    public static StrikeBuilder builder() {
        return new StrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends Strike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Strike> getType() {
        return Strike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("strikeRate"), BigDecimal.class, (Object)this.getStrikeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyer"), processor, IdentifiedPayerReceiver.class, this.getBuyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seller"), processor, IdentifiedPayerReceiver.class, this.getSeller(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class StrikeBuilderImpl
    implements StrikeBuilder {
        protected BigDecimal strikeRate;
        protected IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder buyer;
        protected IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder seller;
        protected String id;

        @Override
        @RosettaAttribute(value="strikeRate", isRequired=true)
        @RuneAttribute(value="strikeRate", isRequired=true)
        public BigDecimal getStrikeRate() {
            return this.strikeRate;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getBuyer() {
            return this.buyer;
        }

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateBuyer() {
            IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder result = this.buyer != null ? this.buyer : (this.buyer = IdentifiedPayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getSeller() {
            return this.seller;
        }

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateSeller() {
            IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder result = this.seller != null ? this.seller : (this.seller = IdentifiedPayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="strikeRate", isRequired=true)
        @RuneAttribute(value="strikeRate", isRequired=true)
        public StrikeBuilder setStrikeRate(BigDecimal _strikeRate) {
            this.strikeRate = _strikeRate == null ? null : _strikeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public StrikeBuilder setBuyer(IdentifiedPayerReceiver _buyer) {
            this.buyer = _buyer == null ? null : _buyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public StrikeBuilder setSeller(IdentifiedPayerReceiver _seller) {
            this.seller = _seller == null ? null : _seller.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public StrikeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public Strike build() {
            return new StrikeImpl(this);
        }

        @Override
        public StrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public StrikeBuilder prune() {
            if (this.buyer != null && !this.buyer.prune().hasData()) {
                this.buyer = null;
            }
            if (this.seller != null && !this.seller.prune().hasData()) {
                this.seller = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrikeRate() != null) {
                return true;
            }
            if (this.getBuyer() != null && this.getBuyer().hasData()) {
                return true;
            }
            if (this.getSeller() != null && this.getSeller().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public StrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StrikeBuilder o = (StrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyer(), (RosettaModelObjectBuilder)o.getBuyer(), this::setBuyer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeller(), (RosettaModelObjectBuilder)o.getSeller(), this::setSeller);
            merger.mergeBasic((Object)this.getStrikeRate(), (Object)o.getStrikeRate(), this::setStrikeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Strike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikeRate, _that.getStrikeRate())) {
                return false;
            }
            if (!Objects.equals(this.buyer, _that.getBuyer())) {
                return false;
            }
            if (!Objects.equals(this.seller, _that.getSeller())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikeRate != null ? this.strikeRate.hashCode() : 0);
            _result = 31 * _result + (this.buyer != null ? this.buyer.hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? this.seller.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StrikeBuilder {strikeRate=" + this.strikeRate + ", buyer=" + this.buyer + ", seller=" + this.seller + ", id=" + this.id + '}';
        }
    }

    public static interface StrikeBuilder
    extends Strike,
    RosettaModelObjectBuilder {
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateBuyer();

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getBuyer();

        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateSeller();

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getSeller();

        public StrikeBuilder setStrikeRate(BigDecimal var1);

        public StrikeBuilder setBuyer(IdentifiedPayerReceiver var1);

        public StrikeBuilder setSeller(IdentifiedPayerReceiver var1);

        public StrikeBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("strikeRate"), BigDecimal.class, (Object)this.getStrikeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyer"), processor, IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder.class, this.getBuyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seller"), processor, IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder.class, this.getSeller(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public StrikeBuilder prune();
    }

    public static class StrikeImpl
    implements Strike {
        private final BigDecimal strikeRate;
        private final IdentifiedPayerReceiver buyer;
        private final IdentifiedPayerReceiver seller;
        private final String id;

        protected StrikeImpl(StrikeBuilder builder) {
            this.strikeRate = builder.getStrikeRate();
            this.buyer = Optional.ofNullable(builder.getBuyer()).map(f -> f.build()).orElse(null);
            this.seller = Optional.ofNullable(builder.getSeller()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="strikeRate", isRequired=true)
        @RuneAttribute(value="strikeRate", isRequired=true)
        public BigDecimal getStrikeRate() {
            return this.strikeRate;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public IdentifiedPayerReceiver getBuyer() {
            return this.buyer;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public IdentifiedPayerReceiver getSeller() {
            return this.seller;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public Strike build() {
            return this;
        }

        @Override
        public StrikeBuilder toBuilder() {
            StrikeBuilder builder = Strike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrikeBuilder builder) {
            Optional.ofNullable(this.getStrikeRate()).ifPresent(builder::setStrikeRate);
            Optional.ofNullable(this.getBuyer()).ifPresent(builder::setBuyer);
            Optional.ofNullable(this.getSeller()).ifPresent(builder::setSeller);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Strike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikeRate, _that.getStrikeRate())) {
                return false;
            }
            if (!Objects.equals(this.buyer, _that.getBuyer())) {
                return false;
            }
            if (!Objects.equals(this.seller, _that.getSeller())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikeRate != null ? this.strikeRate.hashCode() : 0);
            _result = 31 * _result + (this.buyer != null ? this.buyer.hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? this.seller.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Strike {strikeRate=" + this.strikeRate + ", buyer=" + this.buyer + ", seller=" + this.seller + ", id=" + this.id + '}';
        }
    }
}

