/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.CorrelationAndOptionalSequenceModel;
import fpml.confirmation.NotificationMessage;
import fpml.confirmation.NotificationMessageHeader;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.ServiceAdvisory;
import fpml.confirmation.ServiceProcessingStatus;
import fpml.confirmation.ServiceStatus;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.ServiceNotificationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ServiceNotification", builder=ServiceNotificationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ServiceNotification", model="fpml", builder=ServiceNotificationBuilderImpl.class, version="0.17.2")
public interface ServiceNotification
extends NotificationMessage {
    public static final ServiceNotificationMeta metaData = new ServiceNotificationMeta();

    public String getServiceName();

    public ServiceStatus getStatus();

    public ServiceProcessingStatus getProcessingStatus();

    public ServiceAdvisory getAdvisory();

    @Override
    public ServiceNotification build();

    @Override
    public ServiceNotificationBuilder toBuilder();

    public static ServiceNotificationBuilder builder() {
        return new ServiceNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends ServiceNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ServiceNotification> getType() {
        return ServiceNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("serviceName"), String.class, (Object)this.getServiceName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("status"), processor, ServiceStatus.class, this.getStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("processingStatus"), processor, ServiceProcessingStatus.class, this.getProcessingStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("advisory"), processor, ServiceAdvisory.class, this.getAdvisory(), new AttributeMeta[0]);
    }

    public static class ServiceNotificationBuilderImpl
    extends NotificationMessage.NotificationMessageBuilderImpl
    implements ServiceNotificationBuilder {
        protected String serviceName;
        protected ServiceStatus.ServiceStatusBuilder status;
        protected ServiceProcessingStatus.ServiceProcessingStatusBuilder processingStatus;
        protected ServiceAdvisory.ServiceAdvisoryBuilder advisory;

        @Override
        @RosettaAttribute(value="serviceName")
        @RuneAttribute(value="serviceName")
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @RosettaAttribute(value="status")
        @RuneAttribute(value="status")
        public ServiceStatus.ServiceStatusBuilder getStatus() {
            return this.status;
        }

        @Override
        public ServiceStatus.ServiceStatusBuilder getOrCreateStatus() {
            ServiceStatus.ServiceStatusBuilder result = this.status != null ? this.status : (this.status = ServiceStatus.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="processingStatus")
        @RuneAttribute(value="processingStatus")
        public ServiceProcessingStatus.ServiceProcessingStatusBuilder getProcessingStatus() {
            return this.processingStatus;
        }

        @Override
        public ServiceProcessingStatus.ServiceProcessingStatusBuilder getOrCreateProcessingStatus() {
            ServiceProcessingStatus.ServiceProcessingStatusBuilder result = this.processingStatus != null ? this.processingStatus : (this.processingStatus = ServiceProcessingStatus.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="advisory")
        @RuneAttribute(value="advisory")
        public ServiceAdvisory.ServiceAdvisoryBuilder getAdvisory() {
            return this.advisory;
        }

        @Override
        public ServiceAdvisory.ServiceAdvisoryBuilder getOrCreateAdvisory() {
            ServiceAdvisory.ServiceAdvisoryBuilder result = this.advisory != null ? this.advisory : (this.advisory = ServiceAdvisory.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ServiceNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ServiceNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ServiceNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public ServiceNotificationBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ServiceNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel")
        @RuneAttribute(value="correlationAndOptionalSequenceModel")
        public ServiceNotificationBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ServiceNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="serviceName")
        @RuneAttribute(value="serviceName")
        public ServiceNotificationBuilder setServiceName(String _serviceName) {
            this.serviceName = _serviceName == null ? null : _serviceName;
            return this;
        }

        @Override
        @RosettaAttribute(value="status")
        @RuneAttribute(value="status")
        public ServiceNotificationBuilder setStatus(ServiceStatus _status) {
            this.status = _status == null ? null : _status.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="processingStatus")
        @RuneAttribute(value="processingStatus")
        public ServiceNotificationBuilder setProcessingStatus(ServiceProcessingStatus _processingStatus) {
            this.processingStatus = _processingStatus == null ? null : _processingStatus.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="advisory")
        @RuneAttribute(value="advisory")
        public ServiceNotificationBuilder setAdvisory(ServiceAdvisory _advisory) {
            this.advisory = _advisory == null ? null : _advisory.toBuilder();
            return this;
        }

        @Override
        public ServiceNotification build() {
            return new ServiceNotificationImpl(this);
        }

        @Override
        public ServiceNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public ServiceNotificationBuilder prune() {
            super.prune();
            if (this.status != null && !this.status.prune().hasData()) {
                this.status = null;
            }
            if (this.processingStatus != null && !this.processingStatus.prune().hasData()) {
                this.processingStatus = null;
            }
            if (this.advisory != null && !this.advisory.prune().hasData()) {
                this.advisory = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getServiceName() != null) {
                return true;
            }
            if (this.getStatus() != null && this.getStatus().hasData()) {
                return true;
            }
            if (this.getProcessingStatus() != null && this.getProcessingStatus().hasData()) {
                return true;
            }
            return this.getAdvisory() != null && this.getAdvisory().hasData();
        }

        @Override
        public ServiceNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ServiceNotificationBuilder o = (ServiceNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStatus(), (RosettaModelObjectBuilder)o.getStatus(), this::setStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProcessingStatus(), (RosettaModelObjectBuilder)o.getProcessingStatus(), this::setProcessingStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdvisory(), (RosettaModelObjectBuilder)o.getAdvisory(), this::setAdvisory);
            merger.mergeBasic((Object)this.getServiceName(), (Object)o.getServiceName(), this::setServiceName, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ServiceNotification _that = (ServiceNotification)this.getType().cast(o);
            if (!Objects.equals(this.serviceName, _that.getServiceName())) {
                return false;
            }
            if (!Objects.equals(this.status, _that.getStatus())) {
                return false;
            }
            if (!Objects.equals(this.processingStatus, _that.getProcessingStatus())) {
                return false;
            }
            return Objects.equals(this.advisory, _that.getAdvisory());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? this.status.hashCode() : 0);
            _result = 31 * _result + (this.processingStatus != null ? this.processingStatus.hashCode() : 0);
            _result = 31 * _result + (this.advisory != null ? this.advisory.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ServiceNotificationBuilder {serviceName=" + this.serviceName + ", status=" + this.status + ", processingStatus=" + this.processingStatus + ", advisory=" + this.advisory + '}' + " " + super.toString();
        }
    }

    public static interface ServiceNotificationBuilder
    extends ServiceNotification,
    NotificationMessage.NotificationMessageBuilder {
        public ServiceStatus.ServiceStatusBuilder getOrCreateStatus();

        @Override
        public ServiceStatus.ServiceStatusBuilder getStatus();

        public ServiceProcessingStatus.ServiceProcessingStatusBuilder getOrCreateProcessingStatus();

        @Override
        public ServiceProcessingStatus.ServiceProcessingStatusBuilder getProcessingStatus();

        public ServiceAdvisory.ServiceAdvisoryBuilder getOrCreateAdvisory();

        @Override
        public ServiceAdvisory.ServiceAdvisoryBuilder getAdvisory();

        @Override
        public ServiceNotificationBuilder setFpmlVersion(String var1);

        @Override
        public ServiceNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public ServiceNotificationBuilder setActualBuild(Integer var1);

        @Override
        public ServiceNotificationBuilder setHeader(NotificationMessageHeader var1);

        @Override
        public ServiceNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public ServiceNotificationBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ServiceNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ServiceNotificationBuilder setServiceName(String var1);

        public ServiceNotificationBuilder setStatus(ServiceStatus var1);

        public ServiceNotificationBuilder setProcessingStatus(ServiceProcessingStatus var1);

        public ServiceNotificationBuilder setAdvisory(ServiceAdvisory var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("serviceName"), String.class, (Object)this.getServiceName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("status"), processor, ServiceStatus.ServiceStatusBuilder.class, this.getStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("processingStatus"), processor, ServiceProcessingStatus.ServiceProcessingStatusBuilder.class, this.getProcessingStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("advisory"), processor, ServiceAdvisory.ServiceAdvisoryBuilder.class, this.getAdvisory(), new AttributeMeta[0]);
        }

        @Override
        public ServiceNotificationBuilder prune();
    }

    public static class ServiceNotificationImpl
    extends NotificationMessage.NotificationMessageImpl
    implements ServiceNotification {
        private final String serviceName;
        private final ServiceStatus status;
        private final ServiceProcessingStatus processingStatus;
        private final ServiceAdvisory advisory;

        protected ServiceNotificationImpl(ServiceNotificationBuilder builder) {
            super(builder);
            this.serviceName = builder.getServiceName();
            this.status = Optional.ofNullable(builder.getStatus()).map(f -> f.build()).orElse(null);
            this.processingStatus = Optional.ofNullable(builder.getProcessingStatus()).map(f -> f.build()).orElse(null);
            this.advisory = Optional.ofNullable(builder.getAdvisory()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="serviceName")
        @RuneAttribute(value="serviceName")
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @RosettaAttribute(value="status")
        @RuneAttribute(value="status")
        public ServiceStatus getStatus() {
            return this.status;
        }

        @Override
        @RosettaAttribute(value="processingStatus")
        @RuneAttribute(value="processingStatus")
        public ServiceProcessingStatus getProcessingStatus() {
            return this.processingStatus;
        }

        @Override
        @RosettaAttribute(value="advisory")
        @RuneAttribute(value="advisory")
        public ServiceAdvisory getAdvisory() {
            return this.advisory;
        }

        @Override
        public ServiceNotification build() {
            return this;
        }

        @Override
        public ServiceNotificationBuilder toBuilder() {
            ServiceNotificationBuilder builder = ServiceNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ServiceNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getServiceName()).ifPresent(builder::setServiceName);
            Optional.ofNullable(this.getStatus()).ifPresent(builder::setStatus);
            Optional.ofNullable(this.getProcessingStatus()).ifPresent(builder::setProcessingStatus);
            Optional.ofNullable(this.getAdvisory()).ifPresent(builder::setAdvisory);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ServiceNotification _that = (ServiceNotification)this.getType().cast(o);
            if (!Objects.equals(this.serviceName, _that.getServiceName())) {
                return false;
            }
            if (!Objects.equals(this.status, _that.getStatus())) {
                return false;
            }
            if (!Objects.equals(this.processingStatus, _that.getProcessingStatus())) {
                return false;
            }
            return Objects.equals(this.advisory, _that.getAdvisory());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? this.status.hashCode() : 0);
            _result = 31 * _result + (this.processingStatus != null ? this.processingStatus.hashCode() : 0);
            _result = 31 * _result + (this.advisory != null ? this.advisory.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ServiceNotification {serviceName=" + this.serviceName + ", status=" + this.status + ", processingStatus=" + this.processingStatus + ", advisory=" + this.advisory + '}' + " " + super.toString();
        }
    }
}

