/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.QuotationModel;
import fpml.confirmation.SensitivitySet;
import fpml.confirmation.meta.QuotationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Quotation", builder=QuotationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Quotation", model="fpml", builder=QuotationBuilderImpl.class, version="0.17.2")
public interface Quotation
extends RosettaModelObject {
    public static final QuotationMeta metaData = new QuotationMeta();

    public QuotationModel getQuotationModel();

    public List<? extends SensitivitySet> getSensitivitySet();

    public Quotation build();

    public QuotationBuilder toBuilder();

    public static QuotationBuilder builder() {
        return new QuotationBuilderImpl();
    }

    default public RosettaMetaData<? extends Quotation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Quotation> getType() {
        return Quotation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quotationModel"), processor, QuotationModel.class, this.getQuotationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sensitivitySet"), processor, SensitivitySet.class, this.getSensitivitySet(), new AttributeMeta[0]);
    }

    public static class QuotationBuilderImpl
    implements QuotationBuilder {
        protected QuotationModel.QuotationModelBuilder quotationModel;
        protected List<SensitivitySet.SensitivitySetBuilder> sensitivitySet = new ArrayList<SensitivitySet.SensitivitySetBuilder>();

        @Override
        @RosettaAttribute(value="quotationModel", isRequired=true)
        @RuneAttribute(value="quotationModel", isRequired=true)
        public QuotationModel.QuotationModelBuilder getQuotationModel() {
            return this.quotationModel;
        }

        @Override
        public QuotationModel.QuotationModelBuilder getOrCreateQuotationModel() {
            QuotationModel.QuotationModelBuilder result = this.quotationModel != null ? this.quotationModel : (this.quotationModel = QuotationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sensitivitySet")
        @RuneAttribute(value="sensitivitySet")
        public List<? extends SensitivitySet.SensitivitySetBuilder> getSensitivitySet() {
            return this.sensitivitySet;
        }

        @Override
        public SensitivitySet.SensitivitySetBuilder getOrCreateSensitivitySet(int index) {
            if (this.sensitivitySet == null) {
                this.sensitivitySet = new ArrayList<SensitivitySet.SensitivitySetBuilder>();
            }
            return (SensitivitySet.SensitivitySetBuilder)this.getIndex(this.sensitivitySet, index, () -> {
                SensitivitySet.SensitivitySetBuilder newSensitivitySet = SensitivitySet.builder();
                return newSensitivitySet;
            });
        }

        @Override
        @RosettaAttribute(value="quotationModel", isRequired=true)
        @RuneAttribute(value="quotationModel", isRequired=true)
        public QuotationBuilder setQuotationModel(QuotationModel _quotationModel) {
            this.quotationModel = _quotationModel == null ? null : _quotationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sensitivitySet")
        @RuneAttribute(value="sensitivitySet")
        public QuotationBuilder addSensitivitySet(SensitivitySet _sensitivitySet) {
            if (_sensitivitySet != null) {
                this.sensitivitySet.add(_sensitivitySet.toBuilder());
            }
            return this;
        }

        @Override
        public QuotationBuilder addSensitivitySet(SensitivitySet _sensitivitySet, int idx) {
            this.getIndex(this.sensitivitySet, idx, () -> _sensitivitySet.toBuilder());
            return this;
        }

        @Override
        public QuotationBuilder addSensitivitySet(List<? extends SensitivitySet> sensitivitySets) {
            if (sensitivitySets != null) {
                for (SensitivitySet sensitivitySet : sensitivitySets) {
                    this.sensitivitySet.add(sensitivitySet.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sensitivitySet")
        public QuotationBuilder setSensitivitySet(List<? extends SensitivitySet> sensitivitySets) {
            this.sensitivitySet = sensitivitySets == null ? new ArrayList<SensitivitySet.SensitivitySetBuilder>() : (List)sensitivitySets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Quotation build() {
            return new QuotationImpl(this);
        }

        @Override
        public QuotationBuilder toBuilder() {
            return this;
        }

        @Override
        public QuotationBuilder prune() {
            if (this.quotationModel != null && !this.quotationModel.prune().hasData()) {
                this.quotationModel = null;
            }
            this.sensitivitySet = this.sensitivitySet.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getQuotationModel() != null && this.getQuotationModel().hasData()) {
                return true;
            }
            return this.getSensitivitySet() != null && this.getSensitivitySet().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public QuotationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuotationBuilder o = (QuotationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotationModel(), (RosettaModelObjectBuilder)o.getQuotationModel(), this::setQuotationModel);
            merger.mergeRosetta(this.getSensitivitySet(), o.getSensitivitySet(), this::getOrCreateSensitivitySet);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Quotation _that = this.getType().cast(o);
            if (!Objects.equals(this.quotationModel, _that.getQuotationModel())) {
                return false;
            }
            return ListEquals.listEquals(this.sensitivitySet, _that.getSensitivitySet());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotationModel != null ? this.quotationModel.hashCode() : 0);
            _result = 31 * _result + (this.sensitivitySet != null ? this.sensitivitySet.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuotationBuilder {quotationModel=" + this.quotationModel + ", sensitivitySet=" + this.sensitivitySet + '}';
        }
    }

    public static interface QuotationBuilder
    extends Quotation,
    RosettaModelObjectBuilder {
        public QuotationModel.QuotationModelBuilder getOrCreateQuotationModel();

        @Override
        public QuotationModel.QuotationModelBuilder getQuotationModel();

        public SensitivitySet.SensitivitySetBuilder getOrCreateSensitivitySet(int var1);

        public List<? extends SensitivitySet.SensitivitySetBuilder> getSensitivitySet();

        public QuotationBuilder setQuotationModel(QuotationModel var1);

        public QuotationBuilder addSensitivitySet(SensitivitySet var1);

        public QuotationBuilder addSensitivitySet(SensitivitySet var1, int var2);

        public QuotationBuilder addSensitivitySet(List<? extends SensitivitySet> var1);

        public QuotationBuilder setSensitivitySet(List<? extends SensitivitySet> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quotationModel"), processor, QuotationModel.QuotationModelBuilder.class, this.getQuotationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sensitivitySet"), processor, SensitivitySet.SensitivitySetBuilder.class, this.getSensitivitySet(), new AttributeMeta[0]);
        }

        public QuotationBuilder prune();
    }

    public static class QuotationImpl
    implements Quotation {
        private final QuotationModel quotationModel;
        private final List<? extends SensitivitySet> sensitivitySet;

        protected QuotationImpl(QuotationBuilder builder) {
            this.quotationModel = Optional.ofNullable(builder.getQuotationModel()).map(f -> f.build()).orElse(null);
            this.sensitivitySet = Optional.ofNullable(builder.getSensitivitySet()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotationModel", isRequired=true)
        @RuneAttribute(value="quotationModel", isRequired=true)
        public QuotationModel getQuotationModel() {
            return this.quotationModel;
        }

        @Override
        @RosettaAttribute(value="sensitivitySet")
        @RuneAttribute(value="sensitivitySet")
        public List<? extends SensitivitySet> getSensitivitySet() {
            return this.sensitivitySet;
        }

        @Override
        public Quotation build() {
            return this;
        }

        @Override
        public QuotationBuilder toBuilder() {
            QuotationBuilder builder = Quotation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuotationBuilder builder) {
            Optional.ofNullable(this.getQuotationModel()).ifPresent(builder::setQuotationModel);
            Optional.ofNullable(this.getSensitivitySet()).ifPresent(builder::setSensitivitySet);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Quotation _that = this.getType().cast(o);
            if (!Objects.equals(this.quotationModel, _that.getQuotationModel())) {
                return false;
            }
            return ListEquals.listEquals(this.sensitivitySet, _that.getSensitivitySet());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotationModel != null ? this.quotationModel.hashCode() : 0);
            _result = 31 * _result + (this.sensitivitySet != null ? this.sensitivitySet.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Quotation {quotationModel=" + this.quotationModel + ", sensitivitySet=" + this.sensitivitySet + '}';
        }
    }
}

