/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdmissionToTrading;
import fpml.confirmation.BusinessCenter;
import fpml.confirmation.CreditSeniority;
import fpml.confirmation.SettlementTypeEnum;
import fpml.confirmation.meta.ProductSummaryMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ProductSummary", builder=ProductSummaryBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ProductSummary", model="fpml", builder=ProductSummaryBuilderImpl.class, version="0.17.2")
public interface ProductSummary
extends RosettaModelObject {
    public static final ProductSummaryMeta metaData = new ProductSummaryMeta();

    public ZonedDateTime getFinalSettlementDate();

    public SettlementTypeEnum getSettlementType();

    public BusinessCenter getSettlementLocation();

    public CreditSeniority getSeniority();

    public BigDecimal getIndexFactor();

    public AdmissionToTrading getAdmissionToTrading();

    public ProductSummary build();

    public ProductSummaryBuilder toBuilder();

    public static ProductSummaryBuilder builder() {
        return new ProductSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends ProductSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProductSummary> getType() {
        return ProductSummary.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("finalSettlementDate"), ZonedDateTime.class, (Object)this.getFinalSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementLocation"), processor, BusinessCenter.class, this.getSettlementLocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.class, this.getSeniority(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("admissionToTrading"), processor, AdmissionToTrading.class, this.getAdmissionToTrading(), new AttributeMeta[0]);
    }

    public static class ProductSummaryBuilderImpl
    implements ProductSummaryBuilder {
        protected ZonedDateTime finalSettlementDate;
        protected SettlementTypeEnum settlementType;
        protected BusinessCenter.BusinessCenterBuilder settlementLocation;
        protected CreditSeniority.CreditSeniorityBuilder seniority;
        protected BigDecimal indexFactor;
        protected AdmissionToTrading.AdmissionToTradingBuilder admissionToTrading;

        @Override
        @RosettaAttribute(value="finalSettlementDate")
        @RuneAttribute(value="finalSettlementDate")
        public ZonedDateTime getFinalSettlementDate() {
            return this.finalSettlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public BusinessCenter.BusinessCenterBuilder getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        public BusinessCenter.BusinessCenterBuilder getOrCreateSettlementLocation() {
            BusinessCenter.BusinessCenterBuilder result = this.settlementLocation != null ? this.settlementLocation : (this.settlementLocation = BusinessCenter.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority.CreditSeniorityBuilder getSeniority() {
            return this.seniority;
        }

        @Override
        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority() {
            CreditSeniority.CreditSeniorityBuilder result = this.seniority != null ? this.seniority : (this.seniority = CreditSeniority.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="admissionToTrading")
        @RuneAttribute(value="admissionToTrading")
        public AdmissionToTrading.AdmissionToTradingBuilder getAdmissionToTrading() {
            return this.admissionToTrading;
        }

        @Override
        public AdmissionToTrading.AdmissionToTradingBuilder getOrCreateAdmissionToTrading() {
            AdmissionToTrading.AdmissionToTradingBuilder result = this.admissionToTrading != null ? this.admissionToTrading : (this.admissionToTrading = AdmissionToTrading.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalSettlementDate")
        @RuneAttribute(value="finalSettlementDate")
        public ProductSummaryBuilder setFinalSettlementDate(ZonedDateTime _finalSettlementDate) {
            this.finalSettlementDate = _finalSettlementDate == null ? null : _finalSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public ProductSummaryBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ProductSummaryBuilder setSettlementLocation(BusinessCenter _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public ProductSummaryBuilder setSeniority(CreditSeniority _seniority) {
            this.seniority = _seniority == null ? null : _seniority.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public ProductSummaryBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="admissionToTrading")
        @RuneAttribute(value="admissionToTrading")
        public ProductSummaryBuilder setAdmissionToTrading(AdmissionToTrading _admissionToTrading) {
            this.admissionToTrading = _admissionToTrading == null ? null : _admissionToTrading.toBuilder();
            return this;
        }

        @Override
        public ProductSummary build() {
            return new ProductSummaryImpl(this);
        }

        @Override
        public ProductSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductSummaryBuilder prune() {
            if (this.settlementLocation != null && !this.settlementLocation.prune().hasData()) {
                this.settlementLocation = null;
            }
            if (this.seniority != null && !this.seniority.prune().hasData()) {
                this.seniority = null;
            }
            if (this.admissionToTrading != null && !this.admissionToTrading.prune().hasData()) {
                this.admissionToTrading = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFinalSettlementDate() != null) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getSettlementLocation() != null && this.getSettlementLocation().hasData()) {
                return true;
            }
            if (this.getSeniority() != null && this.getSeniority().hasData()) {
                return true;
            }
            if (this.getIndexFactor() != null) {
                return true;
            }
            return this.getAdmissionToTrading() != null && this.getAdmissionToTrading().hasData();
        }

        public ProductSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProductSummaryBuilder o = (ProductSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementLocation(), (RosettaModelObjectBuilder)o.getSettlementLocation(), this::setSettlementLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeniority(), (RosettaModelObjectBuilder)o.getSeniority(), this::setSeniority);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdmissionToTrading(), (RosettaModelObjectBuilder)o.getAdmissionToTrading(), this::setAdmissionToTrading);
            merger.mergeBasic((Object)this.getFinalSettlementDate(), (Object)o.getFinalSettlementDate(), this::setFinalSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexFactor(), (Object)o.getIndexFactor(), this::setIndexFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductSummary _that = this.getType().cast(o);
            if (!Objects.equals(this.finalSettlementDate, _that.getFinalSettlementDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            return Objects.equals(this.admissionToTrading, _that.getAdmissionToTrading());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.finalSettlementDate != null ? this.finalSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.admissionToTrading != null ? this.admissionToTrading.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductSummaryBuilder {finalSettlementDate=" + this.finalSettlementDate + ", settlementType=" + (Object)((Object)this.settlementType) + ", settlementLocation=" + this.settlementLocation + ", seniority=" + this.seniority + ", indexFactor=" + this.indexFactor + ", admissionToTrading=" + this.admissionToTrading + '}';
        }
    }

    public static interface ProductSummaryBuilder
    extends ProductSummary,
    RosettaModelObjectBuilder {
        public BusinessCenter.BusinessCenterBuilder getOrCreateSettlementLocation();

        @Override
        public BusinessCenter.BusinessCenterBuilder getSettlementLocation();

        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority();

        @Override
        public CreditSeniority.CreditSeniorityBuilder getSeniority();

        public AdmissionToTrading.AdmissionToTradingBuilder getOrCreateAdmissionToTrading();

        @Override
        public AdmissionToTrading.AdmissionToTradingBuilder getAdmissionToTrading();

        public ProductSummaryBuilder setFinalSettlementDate(ZonedDateTime var1);

        public ProductSummaryBuilder setSettlementType(SettlementTypeEnum var1);

        public ProductSummaryBuilder setSettlementLocation(BusinessCenter var1);

        public ProductSummaryBuilder setSeniority(CreditSeniority var1);

        public ProductSummaryBuilder setIndexFactor(BigDecimal var1);

        public ProductSummaryBuilder setAdmissionToTrading(AdmissionToTrading var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("finalSettlementDate"), ZonedDateTime.class, (Object)this.getFinalSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementLocation"), processor, BusinessCenter.BusinessCenterBuilder.class, this.getSettlementLocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.CreditSeniorityBuilder.class, this.getSeniority(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("admissionToTrading"), processor, AdmissionToTrading.AdmissionToTradingBuilder.class, this.getAdmissionToTrading(), new AttributeMeta[0]);
        }

        public ProductSummaryBuilder prune();
    }

    public static class ProductSummaryImpl
    implements ProductSummary {
        private final ZonedDateTime finalSettlementDate;
        private final SettlementTypeEnum settlementType;
        private final BusinessCenter settlementLocation;
        private final CreditSeniority seniority;
        private final BigDecimal indexFactor;
        private final AdmissionToTrading admissionToTrading;

        protected ProductSummaryImpl(ProductSummaryBuilder builder) {
            this.finalSettlementDate = builder.getFinalSettlementDate();
            this.settlementType = builder.getSettlementType();
            this.settlementLocation = Optional.ofNullable(builder.getSettlementLocation()).map(f -> f.build()).orElse(null);
            this.seniority = Optional.ofNullable(builder.getSeniority()).map(f -> f.build()).orElse(null);
            this.indexFactor = builder.getIndexFactor();
            this.admissionToTrading = Optional.ofNullable(builder.getAdmissionToTrading()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="finalSettlementDate")
        @RuneAttribute(value="finalSettlementDate")
        public ZonedDateTime getFinalSettlementDate() {
            return this.finalSettlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public BusinessCenter getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="admissionToTrading")
        @RuneAttribute(value="admissionToTrading")
        public AdmissionToTrading getAdmissionToTrading() {
            return this.admissionToTrading;
        }

        @Override
        public ProductSummary build() {
            return this;
        }

        @Override
        public ProductSummaryBuilder toBuilder() {
            ProductSummaryBuilder builder = ProductSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductSummaryBuilder builder) {
            Optional.ofNullable(this.getFinalSettlementDate()).ifPresent(builder::setFinalSettlementDate);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getSettlementLocation()).ifPresent(builder::setSettlementLocation);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
            Optional.ofNullable(this.getIndexFactor()).ifPresent(builder::setIndexFactor);
            Optional.ofNullable(this.getAdmissionToTrading()).ifPresent(builder::setAdmissionToTrading);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductSummary _that = this.getType().cast(o);
            if (!Objects.equals(this.finalSettlementDate, _that.getFinalSettlementDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            return Objects.equals(this.admissionToTrading, _that.getAdmissionToTrading());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.finalSettlementDate != null ? this.finalSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.admissionToTrading != null ? this.admissionToTrading.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductSummary {finalSettlementDate=" + this.finalSettlementDate + ", settlementType=" + (Object)((Object)this.settlementType) + ", settlementLocation=" + this.settlementLocation + ", seniority=" + this.seniority + ", indexFactor=" + this.indexFactor + ", admissionToTrading=" + this.admissionToTrading + '}';
        }
    }
}

