/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.meta.PersonSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PersonSequence", builder=PersonSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PersonSequence", model="fpml", builder=PersonSequenceBuilderImpl.class, version="0.17.2")
public interface PersonSequence
extends RosettaModelObject {
    public static final PersonSequenceMeta metaData = new PersonSequenceMeta();

    public String getHonorific();

    public String getFirstName();

    public List<String> getMiddleName();

    public List<String> getInitial();

    public String getSurname();

    public String getSuffix();

    public PersonSequence build();

    public PersonSequenceBuilder toBuilder();

    public static PersonSequenceBuilder builder() {
        return new PersonSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends PersonSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PersonSequence> getType() {
        return PersonSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("honorific"), String.class, (Object)this.getHonorific(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstName"), String.class, (Object)this.getFirstName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("middleName"), String.class, this.getMiddleName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initial"), String.class, this.getInitial(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("surname"), String.class, (Object)this.getSurname(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("suffix"), String.class, (Object)this.getSuffix(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PersonSequenceBuilderImpl
    implements PersonSequenceBuilder {
        protected String honorific;
        protected String firstName;
        protected List<String> middleName = new ArrayList<String>();
        protected List<String> initial = new ArrayList<String>();
        protected String surname;
        protected String suffix;

        @Override
        @RosettaAttribute(value="honorific")
        @RuneAttribute(value="honorific")
        public String getHonorific() {
            return this.honorific;
        }

        @Override
        @RosettaAttribute(value="firstName", isRequired=true)
        @RuneAttribute(value="firstName", isRequired=true)
        public String getFirstName() {
            return this.firstName;
        }

        @Override
        @RosettaAttribute(value="middleName")
        @RuneAttribute(value="middleName")
        public List<String> getMiddleName() {
            return this.middleName;
        }

        @Override
        @RosettaAttribute(value="initial")
        @RuneAttribute(value="initial")
        public List<String> getInitial() {
            return this.initial;
        }

        @Override
        @RosettaAttribute(value="surname", isRequired=true)
        @RuneAttribute(value="surname", isRequired=true)
        public String getSurname() {
            return this.surname;
        }

        @Override
        @RosettaAttribute(value="suffix")
        @RuneAttribute(value="suffix")
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        @RosettaAttribute(value="honorific")
        @RuneAttribute(value="honorific")
        public PersonSequenceBuilder setHonorific(String _honorific) {
            this.honorific = _honorific == null ? null : _honorific;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstName", isRequired=true)
        @RuneAttribute(value="firstName", isRequired=true)
        public PersonSequenceBuilder setFirstName(String _firstName) {
            this.firstName = _firstName == null ? null : _firstName;
            return this;
        }

        @Override
        @RosettaAttribute(value="middleName")
        @RuneAttribute(value="middleName")
        public PersonSequenceBuilder addMiddleName(String _middleName) {
            if (_middleName != null) {
                this.middleName.add(_middleName);
            }
            return this;
        }

        @Override
        public PersonSequenceBuilder addMiddleName(String _middleName, int idx) {
            this.getIndex(this.middleName, idx, () -> _middleName);
            return this;
        }

        @Override
        public PersonSequenceBuilder addMiddleName(List<String> middleNames) {
            if (middleNames != null) {
                for (String toAdd : middleNames) {
                    this.middleName.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="middleName")
        public PersonSequenceBuilder setMiddleName(List<String> middleNames) {
            this.middleName = middleNames == null ? new ArrayList<String>() : (List)middleNames.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="initial")
        @RuneAttribute(value="initial")
        public PersonSequenceBuilder addInitial(String _initial) {
            if (_initial != null) {
                this.initial.add(_initial);
            }
            return this;
        }

        @Override
        public PersonSequenceBuilder addInitial(String _initial, int idx) {
            this.getIndex(this.initial, idx, () -> _initial);
            return this;
        }

        @Override
        public PersonSequenceBuilder addInitial(List<String> initials) {
            if (initials != null) {
                for (String toAdd : initials) {
                    this.initial.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="initial")
        public PersonSequenceBuilder setInitial(List<String> initials) {
            this.initial = initials == null ? new ArrayList<String>() : (List)initials.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="surname", isRequired=true)
        @RuneAttribute(value="surname", isRequired=true)
        public PersonSequenceBuilder setSurname(String _surname) {
            this.surname = _surname == null ? null : _surname;
            return this;
        }

        @Override
        @RosettaAttribute(value="suffix")
        @RuneAttribute(value="suffix")
        public PersonSequenceBuilder setSuffix(String _suffix) {
            this.suffix = _suffix == null ? null : _suffix;
            return this;
        }

        @Override
        public PersonSequence build() {
            return new PersonSequenceImpl(this);
        }

        @Override
        public PersonSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public PersonSequenceBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getHonorific() != null) {
                return true;
            }
            if (this.getFirstName() != null) {
                return true;
            }
            if (this.getMiddleName() != null && !this.getMiddleName().isEmpty()) {
                return true;
            }
            if (this.getInitial() != null && !this.getInitial().isEmpty()) {
                return true;
            }
            if (this.getSurname() != null) {
                return true;
            }
            return this.getSuffix() != null;
        }

        public PersonSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PersonSequenceBuilder o = (PersonSequenceBuilder)other;
            merger.mergeBasic((Object)this.getHonorific(), (Object)o.getHonorific(), this::setHonorific, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstName(), (Object)o.getFirstName(), this::setFirstName, new AttributeMeta[0]);
            merger.mergeBasic(this.getMiddleName(), o.getMiddleName(), this::addMiddleName);
            merger.mergeBasic(this.getInitial(), o.getInitial(), this::addInitial);
            merger.mergeBasic((Object)this.getSurname(), (Object)o.getSurname(), this::setSurname, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSuffix(), (Object)o.getSuffix(), this::setSuffix, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PersonSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.honorific, _that.getHonorific())) {
                return false;
            }
            if (!Objects.equals(this.firstName, _that.getFirstName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.middleName, _that.getMiddleName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initial, _that.getInitial())) {
                return false;
            }
            if (!Objects.equals(this.surname, _that.getSurname())) {
                return false;
            }
            return Objects.equals(this.suffix, _that.getSuffix());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.honorific != null ? this.honorific.hashCode() : 0);
            _result = 31 * _result + (this.firstName != null ? this.firstName.hashCode() : 0);
            _result = 31 * _result + (this.middleName != null ? this.middleName.hashCode() : 0);
            _result = 31 * _result + (this.initial != null ? this.initial.hashCode() : 0);
            _result = 31 * _result + (this.surname != null ? this.surname.hashCode() : 0);
            _result = 31 * _result + (this.suffix != null ? this.suffix.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PersonSequenceBuilder {honorific=" + this.honorific + ", firstName=" + this.firstName + ", middleName=" + this.middleName + ", initial=" + this.initial + ", surname=" + this.surname + ", suffix=" + this.suffix + '}';
        }
    }

    public static interface PersonSequenceBuilder
    extends PersonSequence,
    RosettaModelObjectBuilder {
        public PersonSequenceBuilder setHonorific(String var1);

        public PersonSequenceBuilder setFirstName(String var1);

        public PersonSequenceBuilder addMiddleName(String var1);

        public PersonSequenceBuilder addMiddleName(String var1, int var2);

        public PersonSequenceBuilder addMiddleName(List<String> var1);

        public PersonSequenceBuilder setMiddleName(List<String> var1);

        public PersonSequenceBuilder addInitial(String var1);

        public PersonSequenceBuilder addInitial(String var1, int var2);

        public PersonSequenceBuilder addInitial(List<String> var1);

        public PersonSequenceBuilder setInitial(List<String> var1);

        public PersonSequenceBuilder setSurname(String var1);

        public PersonSequenceBuilder setSuffix(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("honorific"), String.class, (Object)this.getHonorific(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstName"), String.class, (Object)this.getFirstName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("middleName"), String.class, this.getMiddleName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initial"), String.class, this.getInitial(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("surname"), String.class, (Object)this.getSurname(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("suffix"), String.class, (Object)this.getSuffix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PersonSequenceBuilder prune();
    }

    public static class PersonSequenceImpl
    implements PersonSequence {
        private final String honorific;
        private final String firstName;
        private final List<String> middleName;
        private final List<String> initial;
        private final String surname;
        private final String suffix;

        protected PersonSequenceImpl(PersonSequenceBuilder builder) {
            this.honorific = builder.getHonorific();
            this.firstName = builder.getFirstName();
            this.middleName = Optional.ofNullable(builder.getMiddleName()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.initial = Optional.ofNullable(builder.getInitial()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.surname = builder.getSurname();
            this.suffix = builder.getSuffix();
        }

        @Override
        @RosettaAttribute(value="honorific")
        @RuneAttribute(value="honorific")
        public String getHonorific() {
            return this.honorific;
        }

        @Override
        @RosettaAttribute(value="firstName", isRequired=true)
        @RuneAttribute(value="firstName", isRequired=true)
        public String getFirstName() {
            return this.firstName;
        }

        @Override
        @RosettaAttribute(value="middleName")
        @RuneAttribute(value="middleName")
        public List<String> getMiddleName() {
            return this.middleName;
        }

        @Override
        @RosettaAttribute(value="initial")
        @RuneAttribute(value="initial")
        public List<String> getInitial() {
            return this.initial;
        }

        @Override
        @RosettaAttribute(value="surname", isRequired=true)
        @RuneAttribute(value="surname", isRequired=true)
        public String getSurname() {
            return this.surname;
        }

        @Override
        @RosettaAttribute(value="suffix")
        @RuneAttribute(value="suffix")
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public PersonSequence build() {
            return this;
        }

        @Override
        public PersonSequenceBuilder toBuilder() {
            PersonSequenceBuilder builder = PersonSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PersonSequenceBuilder builder) {
            Optional.ofNullable(this.getHonorific()).ifPresent(builder::setHonorific);
            Optional.ofNullable(this.getFirstName()).ifPresent(builder::setFirstName);
            Optional.ofNullable(this.getMiddleName()).ifPresent(builder::setMiddleName);
            Optional.ofNullable(this.getInitial()).ifPresent(builder::setInitial);
            Optional.ofNullable(this.getSurname()).ifPresent(builder::setSurname);
            Optional.ofNullable(this.getSuffix()).ifPresent(builder::setSuffix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PersonSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.honorific, _that.getHonorific())) {
                return false;
            }
            if (!Objects.equals(this.firstName, _that.getFirstName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.middleName, _that.getMiddleName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initial, _that.getInitial())) {
                return false;
            }
            if (!Objects.equals(this.surname, _that.getSurname())) {
                return false;
            }
            return Objects.equals(this.suffix, _that.getSuffix());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.honorific != null ? this.honorific.hashCode() : 0);
            _result = 31 * _result + (this.firstName != null ? this.firstName.hashCode() : 0);
            _result = 31 * _result + (this.middleName != null ? this.middleName.hashCode() : 0);
            _result = 31 * _result + (this.initial != null ? this.initial.hashCode() : 0);
            _result = 31 * _result + (this.surname != null ? this.surname.hashCode() : 0);
            _result = 31 * _result + (this.suffix != null ? this.suffix.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PersonSequence {honorific=" + this.honorific + ", firstName=" + this.firstName + ", middleName=" + this.middleName + ", initial=" + this.initial + ", surname=" + this.surname + ", suffix=" + this.suffix + '}';
        }
    }
}

